class MonitorEvent {
  String eventContent;
  String createDate;
  String eventDate;
  String eventType;
  String videoId;
  String videoName;
  String videoCode;
  String videoPosition;
  String id;
  String videoMonitorPosition;
  String eventState;
  String onduty;
  String disposalRecord;
  String disposalUserId;
  String disposalUserName;
  String disposalDate;
  String startDate;
  String endDate;

  MonitorEvent();

  MonitorEvent.fromParams(
      {this.disposalDate,
      this.eventContent,
      this.createDate,
      this.eventDate,
      this.eventType,
      this.videoId,
      this.videoName,
      this.videoCode,
      this.videoPosition,
      this.id,
      this.videoMonitorPosition,
      this.eventState,
      this.onduty,
      this.disposalRecord,
      this.disposalUserId,
      this.disposalUserName,
      this.startDate,
      this.endDate});

  MonitorEvent.fromJson(jsonRes) {
    // disposalDate = jsonRes['disposalDate'] ?? '';
    eventContent = jsonRes['eventContent'];
    createDate = jsonRes['createDate'];
    eventDate = jsonRes['eventDate'];
    eventType = jsonRes['eventType'];
    videoId = jsonRes['videoId'];
    videoName = jsonRes['videoName'];
    videoCode = jsonRes['videoCode'];
    videoPosition = jsonRes['videoPosition'];
    id = jsonRes['id'];
    videoMonitorPosition = jsonRes['videoMonitorPosition'];
    eventState = jsonRes['eventState'];
    onduty = jsonRes['onduty'].toString();
    disposalRecord = jsonRes['disposalRecord'];
    disposalUserId = jsonRes['disposalUserId'];
    disposalUserName = jsonRes['disposalUserName'];
    startDate = jsonRes['startDate'];
    endDate = jsonRes['endDate'];
  }

  dynamic toJson() {
    dynamic jsonRes = {};
    jsonRes['eventContent'] = eventContent;
    jsonRes['createDate'] = createDate;
    jsonRes['eventDate'] = eventDate;
    jsonRes['eventType'] = eventType;
    jsonRes['videoId'] = videoId;
    jsonRes['videoName'] = videoName;
    jsonRes['videoCode'] = videoCode;
    jsonRes['videoPosition'] = videoPosition;
    jsonRes['id'] = id;
    jsonRes['videoMonitorPosition'] = videoMonitorPosition;
    jsonRes['eventState'] = eventState;
    jsonRes['onduty'] = onduty;
    jsonRes['disposalRecord'] = disposalRecord;
    jsonRes['disposalUserId'] = disposalUserId;
    jsonRes['disposalUserName'] = disposalUserName;
    jsonRes['disposalDate'] = disposalDate;
    jsonRes['startDate'] = startDate;
    jsonRes['endDate'] = endDate;
    return jsonRes;
  }
}
