# amos_safecontrol_app

基于flutter开发混合app的标准模板，包含常用的http请求、组件通信、路由功能、屏幕适配等。


## 环境配置

- 1、可以参照官网或者通过清华镜像源进行SDK安装。

  - [Flutter官网](https://flutter.dev/)
  - [Flutter中文网](https://flutterchina.club/)
  - [Flutter SDK 清华镜像源](https://mirrors.tuna.tsinghua.edu.cn/flutter/flutter_infra/releases/stable/windows/)

- 2、配置安卓与iOS开发环境

  安卓需要安装 `Android studio`, **iOS** 需要安装`Xcode`

  **注意**: `windows`环境只能开发安卓应用，`Mac`环境都可以开发

- 3. 模板项目基于 **flutter_windows_1.17.3-stable**，为了保持统一性，建议安装此版本

## 包管理网站

[pub.dev](https://pub.dev/)


## 开始

#### 代码规范

需要参照 `Dart` 规范编写一致、健壮、高效的代码。

[Effective Dart](https://www.dartcn.com/guides/language/effective-dart/)

#### 开发工具

推荐使用 `Android Studio`, 也可以使用 `VS Code` ，均需要安装相应的`Dart`和 `Flutter`插件。

#### 运行程序

- 1.执行 `flutter package get`拉取依赖环境
- 2.运行模拟器
- 3.执行 `flutter run lib/main.dart`

#### 项目目录结构说明

>```js
> .
> ├── andorid                // 安卓原生
> ├── ios                    // iOS原生
> ├──  build                 // 对应平台编译文件
> ├──  assets              // 静态资源入口
> └── lib                    // 源代码目录
>    ├── consts              // 常量
>    ├── entry               // 业务入口
>    ├── extension           // 类扩展
>    │── routes              // 系统路由
>    │── model               // 模型类
>    │── service             // 系统服务类
>    │── widgets             //常用组件封装
>    │── viewmodel           // 数据模型类
>    └── view                // 页面元素
>          ├── mine          // 我的模块
>          ├── home          // 首页
>          └── ...
>        └── main.dart        // 项目主入口
>  ├── .gitignore     
>  ├── .metadata
>  ├── pubspec.lock  
>  ├── .pubspec.yaml         // 配置系统依赖、开发依赖以及模块相关信息。
>  └── test                  // 单元测试模块
>```

## 注意点

1. 运行项目前执行 `flutter doctor`进行环境检查，可以排查基本问题。
2. 由于`flutter`对项目文件名限制，不支持驼峰和`-`形式的名称。
