import 'package:equipment_manage/routes/routes.dart' as equipment_manager_routes;
import 'package:fluro/fluro.dart';
import 'package:flutter/material.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';

import 'package:flutter_localizations/flutter_localizations.dart';
import 'package:offline/routes/routes.dart' as offline_routes;
import 'package:safe_control/routes/routes.dart' as safe_control_routes;

import 'routes/routes.dart' as base_routes;
import 'services/application.dart';
import 'utils/app_theme.dart';
import 'view/login/login.dart';

/// test
class MyApp extends StatelessWidget {
  MyApp() {
    final router = FluroRouter();
    base_routes.Routes.configureRoutes(router);
    safe_control_routes.Routes.configureRoutes(router);
    equipment_manager_routes.Routes.configureRoutes(router);
    offline_routes.Routes.configureRoutes(router);
    Application.router = router;
  }

  @override
  Widget build(BuildContext context) {
    SizeFit.initialize(standardSize: 750);
    return teamStationManagement();
  }

  //队站管理
  MaterialApp teamStationManagement() {
    return MaterialApp(
        localizationsDelegates: const [
          GlobalMaterialLocalizations.delegate,
          GlobalWidgetsLocalizations.delegate,
        ],
        supportedLocales: const [
          Locale('zh', 'CH'),
          Locale('en', 'US'),
        ],
        debugShowCheckedModeBanner: false,
        title: '装备管理',
        onGenerateRoute: Application.router.generator,
        theme: AppTheme.norTheme,
        home: Login());
  }
}
