import 'package:flutter/material.dart';

import '../view/platform/platform.dart';
import '../view/profile/profile.dart';
import '../view/statistics_screen.dart';

class PermissionViewManger {
  // 所有的权限信息
  // 包括底部菜单和菜单子项
  final List userPowers;
  final String theme;
  PermissionViewManger(
    this.userPowers,
    this.theme,
  );
  // 获取页面
  List<Widget> getViews() {
    List<Widget> powers = [];
    for (final power in userPowers) {
      final name = power['path'];
      if (name == 'platform') {
        powers.add(Platform(power['children']));
      } else if (name == 'statistic') {
        powers.add(StatisticsScreen(power['children']));
      } else if (name == 'profile') {
        powers.add(MyScreen(power['children']));
      }
    }
    return powers;
  }

  // 获取底部item
  List<BottomNavigationBarItem> getBarItems() {
    List<BottomNavigationBarItem> powers = [];
    for (final power in userPowers) {
      powers.add(
        BottomNavigationBarItem(
            title: Text(
              power['permissionName'],
            ),
            icon: Image.asset(
              'assets/images/${power['frontComponent']}.png',
              width: 25,
              height: 25,
              gaplessPlayback: true,
            ),
            activeIcon: Image.asset('assets/images/${power['frontComponent']}_selected_$theme.png',
                width: 25, height: 25, gaplessPlayback: true)),
      );
    }
    return powers;
  }
}
