import 'package:flutter/material.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';


//消防人员列表

class FireFighterCard extends StatefulWidget {
  @override
  _FireFighterCardState createState() => _FireFighterCardState();
}

class _FireFighterCardState extends State<FireFighterCard> {
  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: EdgeInsets.symmetric(horizontal: 8.px, vertical: 3.px),
      child: Card(
        shape:
            RoundedRectangleBorder(borderRadius: BorderRadius.circular(6.px)),
        shadowColor: Color.fromRGBO(69, 91, 99, 0.08),
        elevation: 4,
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: <Widget>[
            Padding(
              padding: EdgeInsets.only(left: 15.px, top: 9.px),
              child: Text(
                "消防人员列表",
                style: Theme.of(context).textTheme.headline4,
              ),
            ),
            ListView.builder(
                padding: EdgeInsets.only(left: 25.px, right: 15.px, top: 10.px),
                itemCount: 3,
                shrinkWrap: true,
                physics: NeverScrollableScrollPhysics(),
                itemBuilder: (ctx, index) {
                  return buildListContent(context);
                })
          ],
        ),
      ),
    );
  }

  Widget buildListContent(context) {
    return Padding(
      padding: EdgeInsets.only(bottom: 20.px),
      child: Row(
        children: <Widget>[
          Image.asset(
            "assets/images/icon_fighter_image.png",
            width: 48.px,
            height: 56.px,
          ),
          SizedBox(
            width: 15.px,
          ),
          Expanded(
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: <Widget>[
                Text(
                  "消防中队长",
                  style: Theme.of(context).textTheme.headline4,
                ),
                SizedBox(
                  height: 2.px,
                ),
                Text(
                  "王建平",
                  style: Theme.of(context)
                      .textTheme
                      .bodyText1
                      .copyWith(color: Color(0xFF999999)),
                ),
                Text("1589999999",
                    style: Theme.of(context)
                        .textTheme
                        .bodyText1
                        .copyWith(color: Color(0xFF999999)))
              ],
            ),
          ),
          Icon(
            Icons.keyboard_arrow_right,
            color: Color(0xFF999999),
          )
        ],
      ),
    );
  }
}
