import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';

import './statistics/patrolPoint.dart';
import '../consts/color.dart';
import '../consts/share_prefers_key_const.dart';
import '../model/CompanyInfo.dart';
import '../model/configuration_item_model.dart';
import '../utils/GetConfig.dart';

class StatisticsScreen extends StatefulWidget {
  final List userPowers;

  StatisticsScreen(this.userPowers);

  @override
  _StatisticsScreenState createState() => _StatisticsScreenState();
}

class _StatisticsScreenState extends State<StatisticsScreen>
    with AutomaticKeepAliveClientMixin {
  List<ConfigurationItemModel> data = [];

  @override
  bool get wantKeepAlive => true;
  String theme = "blue";
  CompanyInfos company;

  @override
  Widget build(BuildContext context) {
    if (theme.isEmpty) {
      return Scaffold(
        backgroundColor: Color.fromRGBO(242, 246, 249, 1),
        body: Text(""),
      );
    }
    //获取统计数据
    StatisticsPage.queryAuthCompanyLeaves();
    return Scaffold(
        appBar: AppBar(
          title: Text( '统计',),
          centerTitle: true
        ),
        body: Container(
          margin: EdgeInsets.only(top: 10),
          child: ListView.builder(
              itemCount: data.length,
              itemBuilder: (context, index) {
                int type = 4;
                if (data[index].path == '/PointStatusStatistics') {
                  type = 1;
                } else if (data[index].path == '/PlanStatistics') {
                  type = 2;
                } else if (data[index].path == '/TaskStatistics') {
                  type = 3;
                } else if (data[index].path == '/EquipStatistic') {
                  type = 4;
                }
                return Container(
                    child: Stack(
                  children: <Widget>[
                    MyItem(
                        title: data[index].permissionName,
                        context: '',
                        type: type),
                    Container(
                        margin: EdgeInsets.all(30),
                        child: Align(
                          child: Icon(
                            Icons.chevron_right,
                            color: GetConfig.getColor(theme),
                          ),
                          alignment: Alignment.centerRight,
                        ))
                  ],
                ));
              }),
          // ListView(
          //   children: <Widget>[
          //     Container(
          //         height: 10,
          //       ),
          // Container(child:Stack(
          //       children: <Widget>[
          //         MyItem(
          //           title: "巡检点状态统计",
          //           context: "计划状态、部门计划",
          //           type: 1
          //         ),
          //         Container(
          //           margin: EdgeInsets.all(30),
          //           child: Align(
          //             child: Icon(
          //               Icons.chevron_right,
          //               color: GetConfig.getColor(theme),
          //             ),
          //             alignment: Alignment.centerRight,
          //           )
          //         )
          //       ],
          //     )),
          // Container(child:Stack(
          //       children: <Widget>[
          //         MyItem(
          //           title: "计划执行情况统计",
          //           context: "个人、部门、公司计划执行情况",
          //           type: 2
          //         ),
          //         Container(
          //           margin: EdgeInsets.all(30),
          //           child: Align(
          //             child: Icon(
          //               Icons.chevron_right,
          //               color: GetConfig.getColor(theme),
          //             ),
          //             alignment: Alignment.centerRight,
          //           )
          //         )
          //       ],
          //     )),
          // Container(child:Stack(
          //       children: <Widget>[
          //         MyItem(
          //           title: "隐患治理任务统计",
          //           context: "个人、部门、公司任务执行情况",
          //           type: 3
          //         ),
          //         Container(
          //           margin: EdgeInsets.all(30),
          //           child: Align(
          //             child: Icon(
          //               Icons.chevron_right,
          //               color: GetConfig.getColor(theme),
          //             ),
          //             alignment: Alignment.centerRight,
          //           )
          //         )
          //       ],
          //     )),
          // Container(child:Stack(
          //       children: <Widget>[
          //         MyItem(
          //             title: "队站管理数据统计",
          //             context: "队站数据统计",
          //             type: 4
          //         ),
          //         Container(
          //             margin: EdgeInsets.all(30),
          //             child: Align(
          //               child: Icon(
          //                 Icons.chevron_right,
          //                 color: GetConfig.getColor(theme),
          //               ),
          //               alignment: Alignment.centerRight,
          //             )
          //         )
          //       ],
          //     )),
          //   ],
          // ),
        ));
  }

  @override
  void initState() {
    super.initState();
    final usePowers = widget.userPowers;
    for (var json in usePowers) {
      data.add(ConfigurationItemModel.fromJson(json));
    }
    initConfig();
  }

  initConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        this.theme =
            preferences.getString("theme") ?? KColorConstant.DEFAULT_COLOR;
        company = CompanyInfos.fromJson(
            json.decode(preferences.get(SharePrefersKey.companyModelKey)));
      });
    });
  }
}

class StatisticsPage {
  static String queryAuthCompanyLeaves() {
    return "";
  }
}
