import 'package:flutter/material.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';

import '../utils/GetConfig.dart';

class CommonAlertDialog extends Dialog {
  final VoidCallback onCancelTap;
  final VoidCallback onTap;
  final bool barrierDismissible;
  final String title;
  final String content;
  final String cancelTitle;
  final String sureTitle;
  final String subtitle;
  final String theme;
  CommonAlertDialog(
      {Key key,
      this.onCancelTap,
      @required this.onTap,
      this.title = "提示",
      this.cancelTitle = "否",
      this.sureTitle = "是",
      this.content,
      this.barrierDismissible = false,
      this.subtitle,
      this.theme})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () {
        return Future.value(barrierDismissible);
      },
      child: Material(
        type: MaterialType.transparency,
        child: Stack(
          fit: StackFit.expand,
          children: <Widget>[
            GestureDetector(onTap: () {
              if (barrierDismissible) {
                Navigator.of(context).pop();
              }
            }),
            Center(
              child: Padding(
                padding: EdgeInsets.symmetric(horizontal: 60.px),
                child: Container(
                  decoration: ShapeDecoration(
                      color: Colors.white,
                      shape: RoundedRectangleBorder(
                          borderRadius: BorderRadius.circular(5.px))),
                  width: double.infinity,
                  child: Column(
                    mainAxisSize: MainAxisSize.min,
                    children: <Widget>[
                      buildTopBar(context),
                      buildContent(context),
                      buildButton(context)
                    ],
                  ),
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }

  Widget buildTopBar(context) {
    return Stack(children: [
      Container(
        padding: EdgeInsets.symmetric(vertical: 10.px),
        decoration: ShapeDecoration(
            color: Color(0xFFefeff4),
            shape: RoundedRectangleBorder(
                borderRadius: BorderRadius.only(
                    topLeft: Radius.circular(5.px),
                    topRight: Radius.circular(5.px)))),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.center,
          children: <Widget>[
            Text(
              title,
              style: Theme.of(context).textTheme.headline4,
            )
          ],
        ),
      ),
      Positioned(
        right: 10.px,
        top: 8.px,
        child: SvgButton(
          src: "assets/images/icon_close.svg",
          imageSize: 12.px,
          onTap: () {
            Navigator.of(context).pop();
          },
        ),
      )
    ]);
  }

  Widget buildContent(context) {
    return Container(
      constraints: BoxConstraints(minHeight: 100, maxHeight: 300),
      child: SingleChildScrollView(
        child: Padding(
          padding: EdgeInsets.symmetric(vertical: 22.px, horizontal: 20.px),
          child: Column(
            children: <Widget>[
              Text(
                content,
                style: Theme.of(context)
                    .textTheme
                    .headline4
                    .copyWith(fontSize: 15.px),
              ),
              subtitle != null
                  ? Text(
                      "$subtitle",
                      style: Theme.of(context)
                          .textTheme
                          .subtitle2
                          .copyWith(fontSize: 10.px),
                    )
                  : Container()
            ],
          ),
        ),
      ),
    );
  }

  Widget buildButton(context) {
    return Container(
      width: double.infinity,
      height: 40.px,
      child: Row(
        children: <Widget>[
          Expanded(
            child: Container(
              height: 40.px,
              child: RaisedButton(
                color: Colors.white,
                child: Text(cancelTitle,
                    style: Theme.of(context)
                        .textTheme
                        .headline6
                        .copyWith(color: Color(0xFF666666))),
                onPressed: () {
                  Navigator.of(context).pop();
                  onCancelTap();
                },
              ),
            ),
          ),
          Expanded(
            child: Container(
              height: 40.px,
              child: RaisedButton(
                color: GetConfig.getColor(theme),
                child: Text(sureTitle,
                    style: Theme.of(context)
                        .textTheme
                        .headline6
                        .copyWith(color: Colors.white)),
                onPressed: () {
                  Navigator.of(context).pop();
                  onTap();
                },
              ),
            ),
          )
        ],
      ),
    );
  }
}
