import 'package:flutter/material.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';

import '../utils/GetConfig.dart';

class CommonCardItem extends StatelessWidget {
  final String title;
  final String count;
  final Image image;
  final Function onPress;
  final String theme;
  CommonCardItem(
      {this.title, this.count, this.image, this.onPress, this.theme});

  @override
  Widget build(BuildContext context) {
    return InkWell(
      onTap: () {
        if (onPress != null) {
          onPress();
        }
      },
      child: Card(
        shape:
            RoundedRectangleBorder(borderRadius: BorderRadius.circular(5.px)),
        shadowColor: Color(0xFF455b63).withOpacity(0.08),
        child: Row(
          children: <Widget>[
            Padding(
                padding: EdgeInsets.fromLTRB(15.px, 15.px, 10.px, 15.px),
                child: image),
            Expanded(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: <Widget>[
                  Text(
                    title ?? "",
                    style: Theme.of(context)
                        .textTheme
                        .headline2
                        .copyWith(color: Color(0xFF333333)),
                  ),
                  SizedBox(
                    height: 10.px,
                  ),
                  Text(
                    "数量: $count",
                    style: Theme.of(context)
                        .textTheme
                        .subtitle1
                        .copyWith(color: GetConfig.getColor(theme)),
                  )
                ],
              ),
            ),
            Icon(
              Icons.keyboard_arrow_right,
              color: Colors.grey,
            ),
            SizedBox(
              width: 10.px,
            )
          ],
        ),
      ),
    );
  }
}
