import 'package:flutter/material.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';

import 'gradient_text.dart';

class VerticalText extends StatelessWidget {
  final String text;
  final Gradient gradient;
  final String category;

  VerticalText(this.text, {@required this.gradient, @required this.category});

  @override
  Widget build(BuildContext context) {
    return Column(
      children: <Widget>[
        Container(
          padding: EdgeInsets.symmetric(vertical: 5.px),
          child: GradientText(
            text,
            gradient: gradient,
            style: Theme.of(context).textTheme.headline5,
          ),
        ),
        Text(
          category,
          style: Theme.of(context).textTheme.bodyText1,
        )
      ],
    );
  }
}
