class CarStatusModel {
  CarStatusModel({
    this.id,
    this.createDate,
    this.code,
    this.name,
    this.type,
    this.remark,
  });

  String id;
  DateTime createDate;
  String code;
  String name;
  String type;
  dynamic remark;

  factory CarStatusModel.fromJson(Map<String, dynamic> json) => CarStatusModel(
        id: json["id"],
        createDate: DateTime.parse(json["createDate"]),
        code: json["code"],
        name: json["name"],
        type: json["type"],
        remark: json["remark"],
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "createDate": createDate.toIso8601String(),
        "code": code,
        "name": name,
        "type": type,
        "remark": remark,
      };
}
