class EquipmentScanModel {
  EquipmentScanModel({
    this.maintenanceCycle,
    this.equipName,
    this.equipmentCode,
    this.equipCate,
    this.equipCategoryCode,
    this.perfQuota,
    this.equipmentId,
    this.equipmentDetailId,
    this.film,
    this.img,
    this.unit,
    this.qrCode,
    this.manufacturer,
    this.standard,
    this.supplier,
    this.brand,
    this.dateProduced,
    this.remark,
    this.contractCode,
    this.equProperties,
    this.count,
    this.isCarLoad,
    this.carId,
    this.carNum,
    this.stockDetailId,
    this.thumbnail,
    this.goodsAllocationCode,
    this.shelfCellId,
    this.total,
    this.status,
    this.carCompany,
    this.carType,
    this.warehouseName,
    this.amount,
    this.description,
    this.singleOrDouble,
  });

  dynamic singleOrDouble;
  dynamic amount;
  dynamic maintenanceCycle;
  String equipName;
  dynamic equipmentCode;
  dynamic equipCate;
  String equipCategoryCode;
  String perfQuota;
  String equipmentId;
  String equipmentDetailId;
  dynamic film;
  String img;
  String unit;
  String qrCode;
  dynamic manufacturer;
  String standard;
  dynamic supplier;
  String brand;
  String dateProduced;
  dynamic remark;
  String contractCode;
  List<EquProperty> equProperties;
  dynamic count;
  bool isCarLoad;
  dynamic carId;
  dynamic carNum;
  dynamic stockDetailId;
  String thumbnail;
  dynamic goodsAllocationCode;
  dynamic shelfCellId;
  dynamic total;
  String status;
  String carCompany;
  dynamic carType;
  dynamic warehouseName;
  String description;
  factory EquipmentScanModel.fromJson(Map<String, dynamic> json) =>
      EquipmentScanModel(
        amount: json["amount"],
        maintenanceCycle: json["maintenanceCycle"],
        equipName: json["equipName"],
        equipmentCode: json["equipmentCode"],
        equipCate: json["equipCate"],
        equipCategoryCode: json["equipCategoryCode"],
        perfQuota: json["perfQuota"],
        equipmentId: json["equipmentId"],
        equipmentDetailId: json["equipmentDetailId"],
        film: json["film"],
        img: json["img"],
        unit: json["unit"],
        qrCode: json["qrCode"],
        manufacturer: json["manufacturer"],
        standard: json["standard"],
        supplier: json["supplier"],
        brand: json["brand"],
        dateProduced: json["dateProduced"],
        remark: json["remark"],
        contractCode: json["contractCode"],
        equProperties: json["equProperties"] != null
            ? List<EquProperty>.from(
                json["equProperties"].map((x) => EquProperty.fromJson(x)))
            : [],
        count: json["count"],
        isCarLoad: json["isCarLoad"],
        carId: json["carId"],
        carNum: json["carNum"],
        stockDetailId: json["stockDetailId"],
        thumbnail: json["thumbnail"],
        goodsAllocationCode: json["goodsAllocationCode"],
        shelfCellId: json["shelfCellId"],
        total: json["total"].toString(),
        status: json["status"],
        carCompany: json["carCompany"],
        carType: json["carType"],
        warehouseName: json["warehouseName"],
        description: json["description"],
        singleOrDouble: json["singleOrDouble"],
      );

  Map<String, dynamic> toJson() => {
        "amount": amount,
        "singleOrDouble": singleOrDouble,
        "maintenanceCycle": maintenanceCycle,
        "equipName": equipName,
        "equipmentCode": equipmentCode,
        "equipCate": equipCate,
        "equipCategoryCode": equipCategoryCode,
        "perfQuota": perfQuota,
        "equipmentId": equipmentId,
        "equipmentDetailId": equipmentDetailId,
        "film": film,
        "img": img,
        "unit": unit,
        "qrCode": qrCode,
        "manufacturer": manufacturer,
        "standard": standard,
        "supplier": supplier,
        "brand": brand,
        "dateProduced": dateProduced,
        "remark": remark,
        "contractCode": contractCode,
        "equProperties":
            List<dynamic>.from(equProperties.map((x) => x.toJson())),
        "count": count,
        "isCarLoad": isCarLoad,
        "carId": carId,
        "carNum": carNum,
        "stockDetailId": stockDetailId,
        "thumbnail": thumbnail,
        "goodsAllocationCode": goodsAllocationCode,
        "shelfCellId": shelfCellId,
        "total": total,
        "status": status,
        "carCompany": carCompany,
        "carType": carType,
        "warehouseName": warehouseName,
        "description": description,
      };
}

class EquProperty {
  EquProperty({
    this.name,
    this.value,
    this.unit,
    this.symbol,
    this.textLine,
    this.isImportentParameter,
  });

  String name;
  String value;
  String unit;
  String symbol;
  String textLine;
  bool isImportentParameter;

  factory EquProperty.fromJson(Map<String, dynamic> json) => EquProperty(
        name: json["name"],
        value: json["value"],
        unit: json["unit"],
        symbol: json["symbol"],
        textLine: json["textLine"],
        isImportentParameter: json["isImportentParameter"],
      );
  Map<String, dynamic> toJson() => {
        "name": name,
        "value": value,
        "unit": unit,
        "symbol": symbol,
        "textLine": textLine,
        "isImportentParameter": isImportentParameter,
      };
}
