import 'dart:convert';

import 'package:base/model/route_model.dart';
import 'package:fluro/fluro.dart';
import 'package:flutter/material.dart';

import '../view/category/category_detail_list.dart';
import '../view/common/add_fireagent_confirm.dart';
import '../view/common/common_add_fire_agent.dart';
import '../view/common/common_search_list.dart';
import '../view/common/common_single_equipment_list.dart';
import '../view/common/create_scrap.dart';
import '../view/equip_car_extinguish_detail.dart';
import '../view/equip_car_extinguish_list.dart';
import '../view/equip_warehousing.dart';
import '../view/equipment_add_list.dart';
import '../view/equipment_second_info.dart';
import '../view/euipment_info.dart';
import '../view/fire_agent_in_stock.dart';
import '../view/scrap_post_bill.dart';
import '../view/submit_sucess.dart';
import '../view/vehicle/vehcile_manufacturing_enterprise.dart';
import '../view/vehicle/vehicle_loaded.dart';
import '../view/vehicle/vehicle_resume.dart';
import '../view/vehicle_info.dart';
import '../view/vehicledetails/vehicle_details_home.dart';

Handler equipmentInfoHandler = Handler(handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  final result = json.decode(params['params'].first);
  return EquipmentInfo(
    params: (result as Map),
  );
});

Handler equipmentDetailHandler = Handler(handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  RouteModel model = RouteModel(
      category: params['category']?.first,
      title: params['title']?.first,
      item: params['item']?.first,
      extension: json.decode(params['extension']?.first));
  return EquipmentCarExtinguishDetail(
    routeModel: model,
  );
});

Handler equipWareHousingHandler = Handler(handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  RouteModel model = RouteModel(category: params['category']?.first, title: params['title']?.first, item: params['item']?.first);
  return EquipWareHousing(
    routeModel: model,
  );
});

Handler createScrapHandler = Handler(handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  RouteModel model = RouteModel(category: params['category']?.first, title: params['title']?.first, item: params['item']?.first);
  return CreateScrap(routeModel: model);
});

Handler categoryDetailListHandler = Handler(handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  return CategoryDetailList();
});

Handler equipCarExtinguishListHandler = Handler(handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  return EquipCarExtinguishList();
});

Handler vehicleLoadedConfigHandler = Handler(handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  return VehicleLoaded();
});

Handler vehicleResumeHandler = Handler(handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  return VehicleResume();
});

Handler vehicleManufacturingEnterpriseHandler = Handler(handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  return VehicleManufacturingEnterprise();
});

Handler submitSuccessHandler = Handler(handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  RouteModel model = RouteModel(
      category: params['category']?.first,
      title: params['title']?.first,
      item: params['item']?.first,
      extension: json.decode(params['extension']?.first));
  return SubmitSuccess(
    routeModel: model,
  );
});

Handler commonSearchListHandler = Handler(handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  return CommonSearchList();
});
Handler commonSingleEquipmentListHandler = Handler(handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  return CommonSingleEquipmentList();
});

Handler vehicleInfoHandler = Handler(handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  final result = json.decode(params['params'].first);
  return VehicleInfo(
    params: result,
  );
});

Handler equipmentSecondInfoHandler = Handler(handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  RouteModel model = RouteModel(
      category: params['category']?.first,
      title: params['title']?.first,
      item: params['item']?.first,
      extension: params['extension'] != null ? json.decode(params['extension']?.first) : {});
  return EquipmentSecondInfo(
    routeModel: model,
  );
});

Handler equipmentAddListHandler = Handler(handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  RouteModel model = RouteModel(
      category: params['category']?.first,
      title: params['title']?.first,
      item: params['item']?.first,
      extension: params['extension'] != null ? json.decode(params['extension']?.first) : {});
  return EquipmentAddList(
    routeModel: model,
  );
});

Handler commonAddFireAgentHandler = Handler(handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  RouteModel model = RouteModel(
      category: params['category']?.first,
      title: params['title']?.first,
      item: params['item']?.first,
      extension: params['extension'] != null ? json.decode(params['extension']?.first) : {});
  return CommonAddFireAgent(
    routeModel: model,
  );
});

Handler addFireAgentConfirmHandler = Handler(handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  RouteModel model = RouteModel(
      category: params['category']?.first,
      title: params['title']?.first,
      item: params['item']?.first,
      extension: json.decode(params['extension']?.first));
  return AddFireAgentConfirm(
    routeModel: model,
  );
});

Handler scrapPostBillHandler = Handler(handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  RouteModel model = RouteModel(
      category: params['category']?.first,
      title: params['title']?.first,
      item: params['item']?.first,
      extension: params['extension'] != null ? json.decode(params['extension']?.first) : {});
  return ScrapPostBill(
    routeModel: model,
  );
});

Handler fireAgentInStockHandler = Handler(handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  RouteModel model = RouteModel(
      category: params['category']?.first,
      title: params['title']?.first,
      item: params['item']?.first,
      extension: params['extension'] != null ? json.decode(params['extension']?.first) : {});
  return FireAgentInStock(
    routeModel: model,
  );
});

Handler vehicleHomePageHandler = Handler(handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  RouteModel model = RouteModel(
    category: params['category']?.first,
    title: params['title']?.first,
    item: params['item']?.first,
    extension: json.decode(params['extension']?.first),
  );
  return VehicleHomePage(model);
});
