import 'package:flutter/material.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';


class EquipmentCarExtinguishDetailPerformance extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return ListView(
      padding: EdgeInsets.symmetric(horizontal: 8.px, vertical: 8.px),
      children: <Widget>[buildMainCard(context), buildPerformanceCard(context)],
    );
  }

  Widget buildMainCard(BuildContext context) {
    return Card(
      shadowColor: const Color.fromRGBO(69, 91, 99, 0.08),
      shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(8.px)),
      elevation: 8,
      child: Padding(
        padding: EdgeInsets.symmetric(horizontal: 16.px, vertical: 14.px),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: <Widget>[
            Text(
              "核心参数",
              style: Theme.of(context).textTheme.bodyText2,
            ),
            SizedBox(
              height: 23.px,
            ),
            Text("规格型号", style: Theme.of(context).textTheme.bodyText2),
            SizedBox(
              height: 23.px,
            ),
            Text("保养周期 ", style: Theme.of(context).textTheme.bodyText2),
            SizedBox(
              height: 23.px,
            ),
            Text("供应商", style: Theme.of(context).textTheme.bodyText2),
            SizedBox(
              height: 23.px,
            ),
            Text("生产厂商", style: Theme.of(context).textTheme.bodyText2),
            SizedBox(
              height: 23.px,
            ),
            Text("品牌", style: Theme.of(context).textTheme.bodyText2),
            SizedBox(
              height: 23.px,
            ),
            Text("生产日期", style: Theme.of(context).textTheme.bodyText2),
          ],
        ),
      ),
    );
  }

  Widget buildPerformanceCard(BuildContext context) {
    return Card(
      shadowColor: const Color.fromRGBO(69, 91, 99, 0.08),
      shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(8.px)),
      elevation: 8,
      child: Padding(
        padding: EdgeInsets.symmetric(horizontal: 16.px, vertical: 14.px),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: <Widget>[
            Text(
              "性能指标",
              style: Theme.of(context).textTheme.bodyText2,
            ),
            SizedBox(
              height: 23.px,
            ),
            Text("规格型号", style: Theme.of(context).textTheme.bodyText2),
            SizedBox(
              height: 23.px,
            ),
            Text("保养周期 ", style: Theme.of(context).textTheme.bodyText2),
            SizedBox(
              height: 23.px,
            ),
            Text("供应商", style: Theme.of(context).textTheme.bodyText2),
            SizedBox(
              height: 23.px,
            ),
            Text("生产厂商", style: Theme.of(context).textTheme.bodyText2),
            SizedBox(
              height: 23.px,
            ),
            Text("品牌", style: Theme.of(context).textTheme.bodyText2),
            SizedBox(
              height: 23.px,
            ),
            Text("生产日期", style: Theme.of(context).textTheme.bodyText2),
          ],
        ),
      ),
    );
  }
}
