import 'package:base/consts/color.dart';
import 'package:base/model/route_model.dart';
import 'package:base/utils/GetConfig.dart';
import 'package:base/widgets/back_button.dart';
import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';

import '../../model/vehicle_basic_model.dart';
import 'vehicle_basic_information.dart';
import 'vehicle_equipment.dart';
import 'vehicle_resume.dart';
import 'vehicle_specification.dart';
import 'vehicle_supplier.dart';
import 'vehicle_technical_documents.dart';

class VehicleHomePage extends StatefulWidget {
  //final String carid;
  final RouteModel routeModel;

  VehicleHomePage(this.routeModel);

  @override
  _VehisclePageState createState() {
    return _VehisclePageState();
  }
}

class _VehisclePageState extends State<VehicleHomePage>
    with SingleTickerProviderStateMixin {
  BasicBean basicBean = BasicBean();
  String type = ''; //1为装备 3为车辆
  TabController _tabController;

  // BasicBean basicBean;
  List _tabString = [];
  String theme = '';

  @override
  void initState() {
    super.initState();
    basicBean = BasicBean.fromJson(widget.routeModel.extension);
    type = widget.routeModel.category;
    //根据type返回不同tabbar
    if (type == '3') {
      _tabString = ["基本信息", "详细参数", "车载装备", "技术文档", "供应商", "电子履历"];
    } else if (type == '1') {
      _tabString = ["基本信息", "详细参数", "技术文档", "供应商"];
    }
    _tabController = TabController(length: _tabString.length, vsync: this);
    initConfig();
  }

  initConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        this.theme =
            preferences.getString("theme") ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        //backgroundColor: Colors.white,
        appBar: AppBar(
          elevation: 0,
          title: Text(
            type == '3' ? "车辆详细信息" : "装备详细信息",
            style: TextStyle(color: Colors.black),
          ),
          leading: LeadingButton(
            theme: theme,
            onWillScope: true,
            onWillPop: () {
              Navigator.of(context).pop();
            },
          ),
          centerTitle: true,
          bottom: PreferredSize(
            child: Material(
              color: Colors.white,
              child: TabBar(
                //physics: NeverScrollableScrollPhysics(),
                tabs: _tabString
                    .map((e) => Tab(
                          text: e,
                        ))
                    .toList(),
                unselectedLabelColor: Color(0xff333333),
                labelColor: GetConfig.getColor(theme),
                indicatorColor: GetConfig.getColor(theme),
                indicatorSize: TabBarIndicatorSize.label,
                indicatorWeight: 2,
                controller: _tabController,
                isScrollable: type == '3' ? true : false,
              ),
            ),
            preferredSize: Size.fromHeight(40),
          ),
        ),
        body: WillPopScope(
          onWillPop: () {
            Navigator.of(context).pop();
          },
          child: TabBarView(
              physics: NeverScrollableScrollPhysics(),
              controller: _tabController,
              //根据type返回不同tabbar
              children: type == '3'
                  ? [
                      BasicPage(basicBean, type),
                      SpecificaPage(basicBean, type),
                      EquipmentPage(basicBean),
                      TechnicalPage(basicBean, type),
                      SupplierPage(basicBean, type),
                      ResumePage(basicBean),
                    ]
                  : [
                      BasicPage(basicBean, type),
                      SpecificaPage(basicBean, type),
                      TechnicalPage(basicBean, type),
                      SupplierPage(basicBean, type),
                    ]),
        ));
  }
}
