import 'package:flutter/material.dart';
import '../../model/vehicle_basic_model.dart';

class SupplierPage extends StatefulWidget {
  BasicBean baseBean;
  final String type; //1为装备 3为车辆
//供应商
  SupplierPage(this.baseBean, this.type);

  @override
  _SupplierPageState createState() {
    return _SupplierPageState();
  }
}

class _SupplierPageState extends State<SupplierPage> {
  List<dynamic> basicList = [];

  @override
  void initState() {
    //数据处理
    final pream = {
      "name": "企业名称",
      "title": widget.baseBean.manufacturerInfo?.name == null
          ? " "
          : widget.baseBean.manufacturerInfo.name
    };
    basicList.add(pream);
    final pream1 = {
      "name": "生产曾用名",
      "title": widget.baseBean.manufacturerInfo?.oldName == null
          ? " "
          : widget.baseBean.manufacturerInfo.oldName
    };
    basicList.add(pream1);
    final pream2 = {
      "name": "法人代表",
      "title": widget.baseBean.manufacturerInfo?.legalRep == null
          ? " "
          : widget.baseBean.manufacturerInfo.legalRep
    };
    basicList.add(pream2);
    final pream3 = {
      "name": "注册资本(元)",
      "title": widget.baseBean.manufacturerInfo?.registeredCapital == null
          ? " "
          : widget.baseBean.manufacturerInfo.registeredCapital.toString()
    };
    basicList.add(pream3);

    final pream4 = {
      "name": "销售电话",
      "title": widget.baseBean.manufacturerInfo?.salesTel == null
          ? " "
          : widget.baseBean.manufacturerInfo.salesTel
    };
    basicList.add(pream4);

    final pream5 = {
      "name": "服务电话",
      "title": widget.baseBean.manufacturerInfo?.serviceTel == null
          ? " "
          : widget.baseBean.manufacturerInfo.serviceTel
    };
    basicList.add(pream5);

    // final pream6 = {
    //   "name":"企业性质",
    //   "title":widget.baseBean.manufacturerInfo==null?" ":widget.baseBean.manufacturerInfo
    // };
    // basicList.add(pream6);

    // final pream7 = {
    //   "name": "企业位置",
    //   "title":    widget.baseBean.manufacturerInfo.address == null
    //       ? " "
    //       : widget.baseBean.manufacturerInfo.address
    // };
    // basicList.add(pream7);

    final pream8 = {
      "name": "总人数（个）",
      "title": widget.baseBean.manufacturerInfo?.number == null
          ? " "
          : widget.baseBean.manufacturerInfo.number.toString()
    };
    basicList.add(pream8);

    final pream9 = {
      "name": "拟制定标准技术",
      "title": widget.baseBean.manufacturerInfo?.technicalStandard == null
          ? " "
          : widget.baseBean.manufacturerInfo.technicalStandard
    };
    basicList.add(pream9);

    final pream10 = {
      "name": "资质",
      "title": widget.baseBean.manufacturerInfo?.qualifications == null
          ? " "
          : widget.baseBean.manufacturerInfo.qualifications
    };
    basicList.add(pream10);

    final pream11 = {
      "name": "重大研制记录",
      "title": widget.baseBean.manufacturerInfo?.researchRecord == null
          ? " "
          : widget.baseBean.manufacturerInfo.researchRecord
    };
    basicList.add(pream11);

    // final pream12 = {
    // "name":"生产企业类型",
    // "title":widget.baseBean.manufacturerInfo.==null?" ":widget.baseBean.manufacturerInfo
    // };
    // basicList.add(pream12);

    final pream13 = {
      "name": "主要产品特点",
      "title": widget.baseBean.manufacturerInfo?.productType == null
          ? " "
          : widget.baseBean.manufacturerInfo.productType
    };
    basicList.add(pream13);

    final pream14 = {
      "name": "技术人员数",
      "title": widget.baseBean.manufacturerInfo?.technicianNumber == null
          ? " "
          : widget.baseBean.manufacturerInfo.technicianNumber.toString()
    };
    basicList.add(pream14);

    final pream15 = {
      "name": "主要检测设备",
      "title": widget.baseBean.manufacturerInfo?.testingEquipment == null
          ? " "
          : widget.baseBean.manufacturerInfo.testingEquipment
    };
    basicList.add(pream15);

    final pream16 = {
      "name": "历史沿革",
      "title": widget.baseBean.manufacturerInfo?.historicalEvolution == null
          ? " "
          : widget.baseBean.manufacturerInfo.historicalEvolution
    };
    basicList.add(pream16);

    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Material(
        color: Color(0xfff5f5f5),
        child: SingleChildScrollView(
          padding: EdgeInsets.only(left: 10, right: 10, top: 15, bottom: 40),
          child: ListView.builder(
              physics: const NeverScrollableScrollPhysics(),
              key: PageStorageKey('data'),
              itemCount: basicList.length,
              shrinkWrap: true,
              itemBuilder: (BuildContext context, int index) =>
                  ListItemView(index, basicList[index])),
        ));
  }
}

class ListItemView extends StatelessWidget {
  ListItemView(this.row, this.bean, {Key key}) : super(key: key);
  int row;
  dynamic bean;

  //EmergencyBean bean;
  @override
  Widget build(BuildContext context) {
    return Container(
        alignment: Alignment.centerLeft,
        // width: ScreenUtil.screenWidth - 48.getWidth(),

        padding: EdgeInsets.all(10),
        color: row % 2 == 0 ? Colors.white : Color(0xffefeff4),
        //文本颜色
        child: RichText(
          text: TextSpan(
            text: bean['name'] + ' :  ',
            style: TextStyle(fontSize: 12, color: Color(0xff666666)),
            children: <TextSpan>[
              TextSpan(
                  text: bean['title'],
                  style: TextStyle(fontSize: 12, color: Color(0xff333333)))
            ],
          ),
        ));
  }
}
