import 'package:base/consts/color.dart';
import 'package:base/utils/GetConfig.dart';
import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';

import 'package:base/widgets/quote_chip.dart';
import 'package:base/widgets/search_bar.dart';
import 'package:base/widgets/drawer/brand_drawer.dart';
import 'package:base/widgets/drawer/region_drawer.dart';
import 'package:base/widgets/drawer/standard_drawer.dart';
import 'package:base/widgets/drawer/status_drawer.dart';
import 'package:base/widgets/tabbar_button.dart';

class EquipCarExtinguishList extends StatefulWidget {
  @override
  _EquipCarExtinguishListState createState() => _EquipCarExtinguishListState();
}

class _EquipCarExtinguishListState extends State<EquipCarExtinguishList> {
  int type = 0;
  String theme;
  List<Widget> drawers = [
    RegionDrawer(),
    StatusDrawer(),
    BrandDrawer(),
    StandardDrawer()
  ];
  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    initThemeConfig();
  }

  initThemeConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        this.theme =
            preferences.getString("theme") ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: Color(0xFFEEEEEE),
      appBar: AppBar(
        titleSpacing: 0,
        automaticallyImplyLeading: false,
        title: SearchBar(
          title: "查找装备",
          onTap: () {},
        ),
        leading: IconButton(
          icon: Icon(Icons.arrow_back_ios),
          onPressed: () {
            Navigator.of(context).pop();
          },
        ),
        actions: <Widget>[
          Container(
            padding: EdgeInsets.symmetric(horizontal: 10.px),
            child: SvgButton(
              highlightColor: GetConfig.getColor(theme),
              splashColor: GetConfig.getColor(theme),
              src: "assets/images/home_bar_scan.svg",
              size: 30.px,
              imageSize: 18.px,
            ),
          )
        ],
      ),
      endDrawer: drawers[type],
      body: Builder(
        builder: (ctx) {
          return buildEquipCarExtinguishListContent(ctx);
        },
      ),
    );
  }

  // 構建內容
  Widget buildEquipCarExtinguishListContent(context) {
    return Column(
      children: <Widget>[buildTopBar(context), buildList(context)],
    );
  }

  Widget buildTopBar(context) {
    return Container(
      color: Colors.white,
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceEvenly,
        children: <Widget>[
          TopBarButton(
            name: "区域",
            onPressed: () {
              setState(() {
                type = 0;
              });
              Scaffold.of(context).openEndDrawer();
            },
          ),
          TopBarButton(
              name: "状态",
              onPressed: () {
                setState(() {
                  type = 1;
                });
                Scaffold.of(context).openEndDrawer();
              }),
          TopBarButton(
              name: "品牌",
              onPressed: () {
                setState(() {
                  type = 2;
                });
                Scaffold.of(context).openEndDrawer();
              }),
          TopBarButton(
              name: "规格",
              onPressed: () {
                setState(() {
                  type = 3;
                });
                Scaffold.of(context).openEndDrawer();
              })
        ],
      ),
    );
  }

  Widget buildList(BuildContext context) {
    return Expanded(
      child: Padding(
        padding: EdgeInsets.symmetric(horizontal: 8.px, vertical: 5.px),
        child: ListView.separated(
            itemBuilder: (ctx, index) {
              return Card(
                shape: RoundedRectangleBorder(
                    borderRadius: BorderRadius.circular(6.px)),
                elevation: 4,
                shadowColor: Color.fromRGBO(69, 91, 99, 0.08),
                margin: EdgeInsets.zero,
                child: Row(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: <Widget>[
                    Padding(
                      padding: EdgeInsets.fromLTRB(20.px, 28.px, 28.px, 28.px),
                      child: Image.asset(
                        "assets/images/equip_cap.png",
                        width: 78.px,
                      ),
                    ),
                    Expanded(
                      child: Padding(
                        padding: EdgeInsets.symmetric(vertical: 16.px),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: <Widget>[
                            Text(
                              "云梯消防车",
                              style: Theme.of(context).textTheme.headline4,
                            ),
                            SizedBox(
                              height: 5.px,
                            ),
                            Text(
                              "JDX5370GXFPM180/B5",
                              style: Theme.of(context)
                                  .textTheme
                                  .headline3
                                  .copyWith(color: Color(0xFF999999)),
                            ),
                            Text("上海金盾特种车辆装备",
                                style: Theme.of(context)
                                    .textTheme
                                    .headline3
                                    .copyWith(color: Color(0xFF999999))),
                            Wrap(
                              children: List.generate(2, (index) {
                                return Padding(
                                    padding:
                                        EdgeInsets.only(top: 9.px, right: 8.px),
                                    child: QuoteChip(
                                      quote: "额定工作高度:10米",
                                      theme: this.theme,
                                    ));
                              }),
                            ),
                            SizedBox(
                              height: 10.px,
                            ),
                            Text(
                              "数量: 345",
                              style: Theme.of(context).textTheme.subtitle1,
                            )
                          ],
                        ),
                      ),
                    )
                  ],
                ),
              );
            },
            separatorBuilder: (ctx, index) {
              return SizedBox(
                height: 10.px,
              );
            },
            itemCount: 10),
      ),
    );
  }
}
