import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:base/consts/color.dart';
import 'package:base/utils/GetConfig.dart';
import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:sqflite/sqlite_api.dart';

import '../../model/offline_plan_list_output.dart';
import '../../services/dbAccess.dart';
import '../../services/offline_plan_inspection_services.dart';
import '../../view/CheckExecute/checkexec_spot_detail.dart';

class OfflineInspectionSpotScreen extends StatefulWidget {
  @override
  _OfflineInspectionSpotScreenState createState() =>
      _OfflineInspectionSpotScreenState();
}

class _OfflineInspectionSpotScreenState
    extends State<OfflineInspectionSpotScreen>
    with AutomaticKeepAliveClientMixin {
  @override
  bool get wantKeepAlive => true;

  // 根据线路查询点列表数据
  List<Point> pointList = List();

  bool isAnimating = false;
  String theme = '';

  @override
  void initState() {
    super.initState();
    loadData();
    initConfig();
  }

  initConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        this.theme =
            preferences.getString("theme") ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  void loadData() async {
    setState(() {
      isAnimating = true;
    });
    Database db = await dbAccess().openDb();
    // 从本地数据库查询点信息
    List<Map<String, dynamic>> lst = await dbAccess().getPoints(db);

    await dbAccess().closeDb(db);

    // 转换数据
    await getOfflinePointList(lst).then((data) {
      setState(() {
        this.pointList = data;
        isAnimating = false;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    if (null == pointList || pointList.length == 0) {
      return Scaffold(
          appBar: AppBar(
        title: Text(
          "巡检点",
          style: TextStyle(color: Colors.black, fontSize: 19),
        ),
        centerTitle: true,
        elevation: 0.7,
        brightness: Brightness.light,
        backgroundColor: KColorConstant.topBarColor,
        leading: new Container(
          child: GestureDetector(
            onTap: () => Navigator.pop(context),
            child: Icon(Icons.keyboard_arrow_left,
                color: GetConfig.getColor(theme), size: 32),
          ),
        ),
      ));
    }

    return Scaffold(
      appBar: AppBar(
        title: Text(
          "巡检点",
          style: TextStyle(color: Colors.black, fontSize: 19),
        ),
        centerTitle: true,
        elevation: 0.7,
        brightness: Brightness.light,
        backgroundColor: KColorConstant.topBarColor,
        leading: new Container(
          child: GestureDetector(
            onTap: () => Navigator.pop(context),
            child: Icon(Icons.keyboard_arrow_left,
                color: GetConfig.getColor(theme), size: 32),
          ),
        ),
      ),
      body: _getWidget(),
    );
  }

  Widget _getWidget() {
    return new Padding(
        padding: new EdgeInsets.only(top: 5.0),
        child: new Stack(children: <Widget>[
          new Column(
            children: <Widget>[
              new Expanded(
                  child: new Container(
                child: GestureDetector(
                  child: Center(
                    child: new ListView.builder(
                      //ListView的Item
                      itemCount: pointList.length,
                      itemBuilder: (BuildContext context, int index) {
                        return Card(
                            elevation: 0.2,
                            child: new ListTile(
                                isThreeLine: true,
                                dense: false,
                                subtitle: new Column(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: <Widget>[
                                    new Text(
                                      (index + 1).toString() +
                                          "." +
                                          pointList[index].name,
                                      style: new TextStyle(
                                          fontSize: 18.0,
                                          fontWeight: FontWeight.w600),
                                    ),
                                    Padding(
                                      padding: EdgeInsets.only(top: 5),
                                    ),
                                    Text(
                                      "编号:" + pointList[index].pointNO,
                                      style: new TextStyle(
                                          fontSize: 14.0, color: Colors.grey),
                                    ),
                                  ],
                                ),
                                trailing: new Padding(
                                  child: new Icon(Icons.keyboard_arrow_right),
                                  padding: EdgeInsets.only(top: 15),
                                ),
                                onTap: () {
                                  Navigator.push(context,
                                      new MaterialPageRoute(builder: (context) {
                                    return new OfflineCheckExecSpotDetail(
                                        pointList[index]);
                                  }));
                                }));
                      },
                    ),
                  ),
                ),
              ))
            ],
          ),
        ]));
  }

  ScrollController scrollController = new ScrollController();
  GlobalKey globalKey2 = new GlobalKey();

  void _onTapHead(int index) {
    RenderObject renderObject = globalKey2.currentContext.findRenderObject();
    DropdownMenuController controller =
        DefaultDropdownMenuController.of(globalKey2.currentContext);

    scrollController
        .animateTo(scrollController.offset + renderObject.semanticBounds.height,
            duration: new Duration(milliseconds: 150), curve: Curves.ease)
        .whenComplete(() {
      controller.show(index);
    });
  }
}
