import 'package:fluro/fluro.dart';
import 'package:flutter/material.dart';
import '../view/hidedanger_manage/hidden_danger_found.dart';
import '../view/hidedanger_manage/hidden_danger_processed.dart';
import '../view/hidedanger_manage/hidedanger_manage.dart';
import '../view/hidedanger_manage/hidedanger_pending.dart';
import '../view/hidedanger_manage/task_addition/task_addition_screen.dart';
import '../view/inspection_record/record_list_screen.dart';
import '../view/inspection_spot/inspection_spot_screen.dart';
import '../view/move_inspection/move_spot_list_screen.dart';
import '../view/no_plan_inspection/no_plan_inspection.dart';
import '../view/plan_inspection/plan_list_screen.dart';
import '../view/task_calendar/calendar_main.dart';

///---------------日常巡检-------------------
///计划巡检
Handler planPatrolHandler = Handler(
    handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  return PlanListScreen();
});

///无计划巡检
Handler noPlanPatrolHandler = Handler(
    handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  return NoPlanInspection();
});

///移动巡检
Handler moblePatrolHandler = Handler(
    handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  return MoveSpotListScreen();
});

///巡检记录
Handler patrolLogHandler = Handler(
    handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  return RecordListScreen();
});

///巡检点
Handler patrolPointHandler = Handler(
    handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  return InspectionSpotScreen();
});

///巡检日历
Handler patrolCalendarHandler = Handler(
    handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  return CalendarMainPage();
});

///---------------缺陷治理-------------------
Handler myReceiveHandler = Handler(
    handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  return HideDangerPage(1);
});
Handler mySendHandler = Handler(
    handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  return HideDangerPage(2);
});
Handler addTaskHandler = Handler(
    handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  return TaskAdditionScreen();
});
Handler allTaskHandler = Handler(
    handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  return HideDangerPage(0);
});

///---------------隐患治理-------------------
///待处理
Handler pendingHideHandler = Handler(
    handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  return PendingHideDanger();
});

///已处理
Handler processedHiddenHandler = Handler(
    handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  return ProcessedHiddenDanger();
});

///隐患添加
Handler hiddenDangerHandler = Handler(
    handlerFunc: (BuildContext context, Map<String, List<String>> params) {
  return HiddenDangerFound();
});
