import 'dart:io';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';

import 'package:base/consts/color.dart';
import 'package:base/utils/GetConfig.dart';
import 'package:flutter/material.dart';
import 'package:image_picker/image_picker.dart';
import 'package:shared_preferences/shared_preferences.dart';

class ImageList extends StatefulWidget {
  final List<File> imageList;

  const ImageList(this.imageList);

  @override
  State<StatefulWidget> createState() {
    return _ImageListState();
  }
}

class _ImageListState extends State<ImageList> {
  String theme = '';
  List<File> _imageList = [];

  @override
  void initState() {
    super.initState();
    _imageList = widget.imageList ?? [];
    initConfig();
  }

  Future<void> initConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        theme = preferences.getString('theme') ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  List<Widget> getImagesWidget() {
    List<Widget> widgets = [];
    _imageList.forEach((c) {
      widgets.add(Stack(
        children: <Widget>[
          Container(
            width: 110,
            height: 140,
            margin: const EdgeInsets.only(top: 15, left: 5),
            child: GestureDetector(
              child: c.path.substring(c.path.lastIndexOf('.')) == '.jpg' ? Image.file(c) : VideoViewSmallPage(c),
              onTap: () {
                String fileType = c.path.substring(c.path.lastIndexOf('.'));
                if (fileType == '.jpg') {
                  Navigator.push(context, MaterialPageRoute(builder: (context) {
                    return ImageView(Image.file(c, repeat: ImageRepeat.repeat));
                  }));
                } else {
                  // 视频
                  Navigator.push(context, MaterialPageRoute(builder: (context) {
                    return VideoViewPage(c);
                  }));
                }
              },
            ),
          ),
          Positioned(
              right: 0.0,
              top: 0.0,
              left: 100,
              child: InkWell(
                  child: Icon(Icons.cancel, color: Theme.of(context).disabledColor),
                  onTap: () {
                    setState(() {
                      _imageList.remove(c);
                    });
                  }))
        ],
      ));
    });

    // 拍照按钮
    widgets.add(Container(
        width: 110,
        height: 140,
        margin: const EdgeInsets.only(top: 15, left: 10),
        alignment: Alignment.bottomCenter,
        child: GestureDetector(
          onTap: () {
            ImagePicker.pickImage(source: ImageSource.camera).then((c) {
              setState(() {
                if (c != null) {
                  _imageList.insert(0, c);
                }
              });
            });
          },
          onLongPress: () {
            ImagePicker.pickVideo(source: ImageSource.camera).then((f) {
              setState(() {
                if (f != null) {
                  _imageList.insert(0, f);
                }
              });
            });
          },
          child: Container(
            alignment: Alignment.center,
            decoration: BoxDecoration(
                border: Border.all(color: Colors.grey[200], width: 0.5), // 边色与边宽度
                color: Colors.grey[200]),
            padding: const EdgeInsets.only(top: 40),
            child: Column(
              children: <Widget>[
                Container(
                  child: Icon(
                    Icons.camera_alt,
                    size: 40,
                    color: Theme.of(context).primaryColor,
                  ),
                )
              ],
            ),
          ),
        )));
    return widgets;
  }

  @override
  Widget build(BuildContext context) {
    if (theme.isEmpty) {
      return const Scaffold(body: Text(''));
    }
    return Scaffold(
      appBar: AppBar(
        title: const Text(
          '现场照片',
        ),
        centerTitle: true,
        elevation: 0.2,
        brightness: Brightness.light,
        actions: <Widget>[
          Container(
            padding: const EdgeInsets.only(right: 20),
            child: GestureDetector(
              child: const Text(
                '提交',
                style: TextStyle(color: Colors.white, fontSize: 18),
              ),
              onTap: () {
                Navigator.pop(context, _imageList);
              },
            ),
            alignment: Alignment.centerLeft,
          ),
        ],
      ),
      body: Wrap(children: getImagesWidget()),
    );
  }
}
