import 'package:flutter/material.dart';
import 'package:base/consts/color.dart';
import 'package:base/utils/GetConfig.dart';
import 'package:shared_preferences/shared_preferences.dart';

class TextView extends StatefulWidget {
  final String text;
  final bool readonly;

  const TextView({this.text, this.readonly = false});

  @override
  State<StatefulWidget> createState() {
    return _TextView();
  }
}

class _TextView extends State<TextView> {
  final TextEditingController _textEditingController = TextEditingController();
  String theme = '';

  @override
  void initState() {
    super.initState();
    widget.text == null || widget.text.isEmpty
        ? _textEditingController.text = ''
        : _textEditingController.text = widget.text;
    initConfig();
  }

  initConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        theme = preferences.getString('theme') ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    if (theme.isEmpty) {
      return const Scaffold(body: Text(''));
    }
    return Scaffold(
        appBar: AppBar(
          title: const Text(
            '备注说明',
          ),
          centerTitle: true,
          elevation: 0.7,
          brightness: Brightness.light,
          leading: Container(
            child: GestureDetector(
              onTap: () {
                if (_textEditingController.text != '' && _textEditingController.text != widget.text) {
                  showDialog(
                      context: context,
                      barrierDismissible: false,
                      builder: (_) => AlertDialog(
                              title: Column(
                                children: const <Widget>[
                                  Text('信息'),
                                  Divider(height: 2),
                                ],
                              ),
                              content: const Text('内容发生变化是否退出?'),
                              actions: <Widget>[
                                FlatButton(
                                  child: const Text('关闭', style: TextStyle(fontSize: 20, color: Colors.grey)),
                                  onPressed: () {
                                    Navigator.of(context).pop();
                                  },
                                ),
                                FlatButton(
                                  child: const Text('退出', style: TextStyle(fontSize: 20, color: Colors.grey)),
                                  onPressed: () {
                                    Navigator.of(context).pop();
                                    Navigator.of(context).pop();
                                  },
                                ),
                              ])).then((v) {
                    return v;
                  });
                } else {
                  Navigator.pop(context, _textEditingController.text);
                }
              },
              child: const Icon(Icons.keyboard_arrow_left, color: Colors.white, size: 32),
            ),
          ),
          actions: <Widget>[
            (widget.readonly)
                ? Container()
                : IconButton(
                    icon: const Icon(Icons.save),
                    color: Colors.white,
                    onPressed: () {
                      Navigator.pop(context, _textEditingController.text);
                    },
                  )
          ],
        ),
        body: Column(
          children: [
            widget.readonly
                ? Container(
                    padding: const EdgeInsets.only(left: 10.0, right: 10.0, top: 5),
                    child: Text(widget.text),
                  )
                : Container(
                    child: TextField(
                      maxLines: 10,
                      autofocus: true,
                      controller: _textEditingController,
                      decoration: InputDecoration(
                        border: InputBorder.none,
                        fillColor: Colors.grey[200],
                        filled: true,
                        contentPadding: const EdgeInsets.only(left: 10.0, right: 10.0, top: 5),
                      ),
                    ),
                    margin: const EdgeInsets.all(10),
                  ),
          ],
        ),
        resizeToAvoidBottomPadding: true);
  }
}
