import 'package:base/consts/color.dart';
import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';

import '../../model/Hidden_Danger/hidden_danger_model.dart';

class HiddenDangerProcessedRectificationMeasuresShow extends StatefulWidget {
  HideDangerInfoModel initData;

  HiddenDangerProcessedRectificationMeasuresShow(this.initData);

  @override
  _HiddenDangerProcessedRectificationMeasuresShow createState() => _HiddenDangerProcessedRectificationMeasuresShow();
}

class _HiddenDangerProcessedRectificationMeasuresShow extends State<HiddenDangerProcessedRectificationMeasuresShow> {
  List<dynamic> reviewNotes = [];
  String theme = '';

  @override
  void initState() {
    super.initState();
    initInfo();
  }

  Future<void> initInfo() async {
    await SharedPreferences.getInstance().then((data) {
      if (data != null) {
        setState(() {
          theme = data.getString('theme') ?? KColorConstant.DEFAULT_COLOR;
        });
      }
    }).then((data) {
      if (widget.initData != null) {
        if (mounted) {
          setState(() {
            /* var measures = json.encode(widget.initData.reformJson);
            reviewNotes.addAll(json.decode(measures)['rectMeasures']);*/
            Map reform = widget.initData.reformJson as Map;
            reviewNotes.addAll(reform['rectMeasures']);
          });
        }
      }
    });
  }

  @override
  Widget build(BuildContext context) {
    if (widget.initData == null) {
      return Scaffold(
          appBar: AppBar(
        title: const Text(
          '治理措施',
        ),
        centerTitle: true,
        elevation: 0.2,
        brightness: Brightness.light,
      ));
    }

    return Scaffold(
      appBar: AppBar(
        title: const Text(
          '治理措施',
        ),
        centerTitle: true,
        elevation: 0.2,
        brightness: Brightness.light,
      ),
      body: SingleChildScrollView(
        child: Container(
          color: Colors.white,
          child: Column(
            children: <Widget>[
              //隐患名称
              Row(
                children: <Widget>[
                  Expanded(
                    flex: 5,
                    child: Container(
                      padding: const EdgeInsets.only(left: 10, top: 10),
                      width: 150,
                      height: 50,
                      child: const Text(
                        '隐患名称',
                        style: TextStyle(fontWeight: FontWeight.w500, fontSize: 18, fontFamily: 'Source Han Sans CN'),
                      ),
                    ),
                  ),
                  Expanded(
                    flex: 10,
                    child: Text(widget.initData.dangerName ?? '-'),
                  ),
                ],
              ),
              //隐患等级
              Row(
                children: <Widget>[
                  Expanded(
                    flex: 5,
                    child: Container(
                      padding: const EdgeInsets.only(left: 10, top: 10),
                      width: 150,
                      height: 50,
                      child: const Text(
                        '隐患等级',
                        style: TextStyle(fontWeight: FontWeight.w500, fontSize: 18, fontFamily: 'Source Han Sans CN'),
                      ),
                    ),
                  ),
                  Expanded(
                    flex: 10,
                    child: Text(
                      widget.initData.levelDesc ?? '-',
                      style: const TextStyle(color: Colors.orange),
                    ),
                  ),
                ],
              ),
              Container(
                color: Colors.grey[100],
                height: 10,
              ),
              //控制措施
              Row(
                children: <Widget>[
                  Expanded(
                    flex: 10,
                    child: Container(
                      padding: const EdgeInsets.only(left: 10, top: 10),
                      height: 50,
                      child: const Text(
                        '控制措施',
                        textAlign: TextAlign.left,
                        style: TextStyle(fontWeight: FontWeight.w500, fontSize: 18, fontFamily: 'Source Han Sans CN'),
                      ),
                    ),
                  ),
                ],
              ),

              Column(
                  children: reviewNotes.map((f) {
                return Column(
                  children: <Widget>[
                    Container(
                      padding: const EdgeInsets.only(left: 10, top: 5, bottom: 5, right: 10),
                      child: Row(
                        children: <Widget>[
                          Expanded(
                            child: Text(
                              f.toString(),
                              style: const TextStyle(fontSize: 16),
                            ),
                            flex: 10,
                          ),
                        ],
                      ),
                    ),
                    const Divider(),
                  ],
                );
              }).toList()),
            ],
          ),
        ),
      ),
    );
  }
}
