import 'package:base/consts/color.dart';
import 'package:base/utils/GetConfig.dart';
import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';

import '../../model/Hidden_Danger/hidden_danger_model.dart';
import '../../view/hidedanger_manage/hidden_danger_found.dart';

class HiddenRectificationMeasures extends StatefulWidget {
  HideDangerInfoModel initData;
  List<String> rectMeasures;

  HiddenRectificationMeasures(this.initData, this.rectMeasures);

  @override
  _HiddenRectificationMeasures createState() => _HiddenRectificationMeasures();
}

class _HiddenRectificationMeasures extends State<HiddenRectificationMeasures> {
  var radioValue = 0;
  String theme = '';
  final TextEditingController _controller = TextEditingController();

  Map<String, TextEditingController> controllers = {};

  @override
  void initState() {
    initInfo();
  }

  initInfo() async {
    await SharedPreferences.getInstance().then((data) {
      if (data != null) {
        setState(() {
          this.theme = data.getString("theme") ?? KColorConstant.DEFAULT_COLOR;
        });
      }
    });
  }

  @override
  Widget build(BuildContext context) {
    if (widget.initData == null) {
      return Scaffold(
        appBar: AppBar(
          title: const Text(
            '整改措施',
          ),
          actions: <Widget>[],
          centerTitle: true,
          elevation: 0.2,
          brightness: Brightness.light,
        ),
      );
    }

    return Scaffold(
      appBar: AppBar(
        title: const Text(
          '整改措施',
        ),
        actions: <Widget>[
          Align(
              child: Padding(
            padding: const EdgeInsets.only(right: 8),
            child: GestureDetector(
              onTap: () {
                if (_controller.text.isNotEmpty) {
                  widget.rectMeasures.add(_controller.text);
                }
                Navigator.pop(context);
              },
              child: const Icon(
                Icons.save,
                size: 25,
              ),
            ),
          ))
        ],
        centerTitle: true,
        elevation: 0.2,
        brightness: Brightness.light,
      ),
      body: SingleChildScrollView(
        child: Container(
          color: Colors.white,
          child: Column(
            children: <Widget>[
              //隐患名称
              Row(
                children: <Widget>[
                  Expanded(
                    flex: 5,
                    child: Container(
                      padding: const EdgeInsets.only(left: 10, top: 10),
                      width: 150,
                      height: 50,
                      child: const Text(
                        "隐患名称",
                        style: TextStyle(fontWeight: FontWeight.w500, fontSize: 18),
                      ),
                    ),
                  ),
                  Expanded(
                    flex: 10,
                    child: Text(widget.initData.dangerName ?? "-"),
                  ),
                ],
              ),
              //隐患等级
              Row(
                children: <Widget>[
                  Expanded(
                    flex: 5,
                    child: Container(
                      padding: const EdgeInsets.only(left: 10, top: 10),
                      width: 150,
                      height: 50,
                      child: const Text(
                        '隐患等级',
                        style: TextStyle(fontWeight: FontWeight.w500, fontSize: 18),
                      ),
                      //     flex: 19,
                      //   ),
                      // ],),
                    ),
                  ),
                  Expanded(
                    flex: 10,
                    child: Text(
                      this.widget.initData.levelDesc ?? "",
                      style: TextStyle(color: this.widget.initData.level == 1 ? Colors.orange : Colors.red),
                    ),
                  ),
                ],
              ),
              Container(
                color: Colors.grey[100],
                height: 10,
              ),

              //控制措施
              Row(
                children: <Widget>[
                  Expanded(
                    flex: 10,
                    child: Container(
                      padding: EdgeInsets.only(left: 10, top: 10),
                      height: 50,
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.start,
                        children: <Widget>[
                          Expanded(
                            child: Text(
                              "控制措施",
                              textAlign: TextAlign.left,
                              style: TextStyle(fontWeight: FontWeight.w500, fontSize: 18),
                            ),
                            flex: 9,
                          ),
                        ],
                      ),
                    ),
                  ),
                  Expanded(
                    flex: 1,
                    child: Container(
                      child: GestureDetector(
                        child: Icon(
                          Icons.add_comment,
                          color: Theme.of(context).primaryColor,
                          size: 25,
                        ),
                        onTap: () {
                          if (this._controller.text == "") {
                            HiddenDangerFound.popUpMsg("未输入内容");
                            return false;
                          }
                          if (!this.widget.rectMeasures.contains(this._controller.text)) {
                            setState(() {
                              this.widget.rectMeasures.add(this._controller.text);
                              this._controller.text = "";
                            });
                          }
                        },
                      ),
                    ),
                  ),
                ],
              ),
              Column(
                  children: this.widget.rectMeasures.map((f) {
                return Column(
                  children: <Widget>[
                    Container(
                      padding: EdgeInsets.only(left: 10, top: 5, bottom: 5),
                      child: Row(
                        children: <Widget>[
                          Expanded(
                            child: Text(
                              f,
                              style: TextStyle(fontSize: 16),
                            ),
                            flex: 9,
                          ),
                          Expanded(
                            flex: 1,
                            child: GestureDetector(
                              child: Icon(
                                Icons.clear,
                                color: Colors.red,
                              ),
                              onTap: () {
                                setState(() {
                                  this.widget.rectMeasures.removeAt(this.widget.rectMeasures.indexOf(f));
                                });
                              },
                            ),
                          ),
                        ],
                      ),
                    ),
                  ],

                  // Text(f),
                );
              }).toList()),
              Container(
                width: MediaQuery.of(context).size.width - 50,
                height: 200,
                margin: EdgeInsets.only(top: 30, bottom: 30),
                decoration: BoxDecoration(color: Color.fromRGBO(244, 244, 244, 1)),
                child: TextField(
                  autofocus: false,
                  maxLength: 500,
                  controller: _controller,
                  enableInteractiveSelection: true,
                  maxLines: null,
                  decoration: InputDecoration(
                    contentPadding: const EdgeInsets.symmetric(vertical: 10.0, horizontal: 10),
                    border: InputBorder.none,
                    hintText: "请输入控制措施",
                    filled: true,
                    fillColor: Color.fromRGBO(244, 244, 244, 1),
                  ),
                  onEditingComplete: () {
                    print(this._controller.text);
                  },
                ),
              ),
            ],
          ),
        ),
      ),
    );
  }
}
