import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:base/consts/color.dart';
import 'package:base/consts/external_assets_package_key.dart';
import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';

import './hide_danger_page_mysend.dart';
import './hide_danger_page_mytask.dart';
import './inspection_task_screening_page.dart';
import './task_addition/task_addition_screen.dart';
import '../../model/Task/TaskContentInput.dart';
import 'hide_danger_page_all.dart';

class HideDangerPage extends StatefulWidget {
  final int idx;

  const HideDangerPage(this.idx);

  @override
  _HideDangerPageState createState() => _HideDangerPageState();
}

class _HideDangerPageState extends State<HideDangerPage> with SingleTickerProviderStateMixin {
  TabController _controller;
  var titles = ['全部任务', '我接收', '我发起', '筛选'];
  TaskContentInput taskContentInput = TaskContentInput();
  String theme = '';

  @override
  void initState() {
    super.initState();
    _controller = TabController(vsync: this, initialIndex: widget.idx, length: titles.length);
    initConfig();
  }

  @override
  void dispose() {
    _controller.dispose();
    super.dispose();
  }

  Future<void> initConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        theme = preferences.getString('theme') ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    if (theme.isEmpty) {
      return const Scaffold(body: Text(''));
    }
    return Scaffold(
        backgroundColor: Colors.white,
        appBar: AppBar(
          title: const Text(
            '任务列表',
          ),
          centerTitle: true,
          elevation: 0.2,
          brightness: Brightness.light,
          actions: <Widget>[
            IconButton(
              icon: const Icon(Icons.add_circle_outline_outlined),
              tooltip: '添加任务',
              onPressed: () {
                Navigator.push(context, MaterialPageRoute(builder: (context) => const TaskAdditionScreen()));
              },
            ),
          ],
        ),
        body: Column(
          children: <Widget>[
            TabBar(
              controller: _controller,
              labelColor: Theme.of(context).primaryColor,
              indicatorColor: Theme.of(context).primaryColor,
              indicatorSize: TabBarIndicatorSize.label,
              indicatorWeight: 1.0,
              isScrollable: true,
              labelStyle: const TextStyle(fontSize: 16),
              unselectedLabelColor: Colors.grey,
              tabs: [
                const Tab(text: '全部任务'),
                const Tab(text: '我接收'),
                const Tab(text: '我发起'),
                Tab(
                  child: TouchCallBack(
                    child: Row(
                      children: <Widget>[
                        Container(
                          height: 30,
                          width: 1,
                          color: Colors.grey[200],
                        ),
                        Container(
                          width: 4,
                        ),
                        Text(
                          titles[3],
                          style: TextStyle(color: Colors.grey[700], fontSize: 15),
                        ),
                        Icon(
                          Icons.filter_alt_outlined,
                          size: 20,
                          color: Theme.of(context).primaryColor,
                        )
                      ],
                    ),
                    onPressed: () {
                      Navigator.push(
                          context,
                          MaterialPageRoute(
                              builder: (context) => TaskScreenPage((data, onlyMe) => callBack(data, onlyMe))));
                    },
                  ),
                )
              ],
            ),
            const Padding(
              padding: EdgeInsets.only(top: 2),
            ),
            const Divider(
              height: 1,
            ),
            Expanded(
              child: TabBarView(
                controller: _controller,
                children: <Widget>[
                  HiderManageAllPage(taskContentInput),
                  HiderManageMyTaskPage(taskContentInput),
                  HiderManageMySendPage(taskContentInput),
                  Container()
                ],
              ),
            )
          ],
        ));
  }

  void callBack(TaskContentInput data, bool onlyMe) {
    setState(() {
      taskContentInput = data;
    });
  }
}
