import 'package:flutter/material.dart';

/// 存放系统统一样式
/// - 字体大小
/// - 字体 style
/// - 颜色系列
///
///

class CoreStyles {
  static const textSizeMin = 12.0;
  static const textSizeSmall = 14.0;
  static const textSizeMid = 16.0;

  /// 通用字体大小
  static const textSize = 18.0;
  static const textSizeBig = 23.0;
  static const textSizeLarge = 30.0;

  /// text color
  static const Color white = Color(0xffffffff);
  static const Color subTextColor = Color(0xff959595);
  static const Color subLightTextColor = Color(0xffc4c4c4);
  static const Color primaryValue = Color(0xffffffff);
  static const Color primaryLightValue = Color(0xffffffff);
  static const Color primaryBlueValue = Color(0xff345fa6); // #345fa6 web 通用 blue 颜色
  static const Color primaryDarkValue = Color(0xff333333); // #333333

  /// textstyle

  /// app bar white
  static TextStyle appBarTitleWhiteTextStyle =
      const TextStyle(fontSize: 18, color: Colors.white);

  /// app bar black
  static TextStyle appBarTitleBlackTextStyle =
      const TextStyle(fontSize: 16, color: Colors.black);

  static const minText =
      TextStyle(color: subLightTextColor, fontSize: textSizeMin);

  static const smallTextWhite =
      TextStyle(color: white, fontSize: textSizeSmall);

  static const smallText =
      TextStyle(color: primaryDarkValue, fontSize: textSizeSmall);

  static const smallTextBold = TextStyle(
      color: primaryDarkValue,
      fontSize: textSizeSmall,
      fontWeight: FontWeight.bold);
}
