import 'dart:io';

import 'package:base/services/api_address.dart';
import 'package:dio/dio.dart';
import 'package:jcs_airport/consts/file_type.dart';
import 'package:jcs_airport/consts/url_const.dart';
import 'package:jcs_airport/utils/request.dart';
import 'package:jcs_airport/view/common/image_picker.dart';
import 'package:jcs_airport/viewmodel/confirm_alam.dart';
import 'package:jcs_airport/viewmodel/monitor_event.dart';

class API {

  ///------------------------------------------------AMOS平台---------------------------------------------------
  ///获取单位树
  static Future getDepartmentTree() async {
    return await AmosHttp.client.get(URLConst.companyTree2);
  }

  ///根据公司id查询机构用户
  static Future agencyuserByCompany(String companyId) async {
    return await AmosHttp.client.get(URLConst.agencyuserByCompany + companyId);
  }

  //报警人list
  static Future agencygetConfirmUser() async {
    return await AmosHttp.client.get(URLConst.agencygetConfirmUser);
  }

  /// 根据类型统计
  static Future countByMsgType() async {
    return await AmosHttp.client.get(URLConst.countByMsgType,query: {'terminal': 'APP','category':0}, contentType: ContentType.FORM_URL_ENCODED);
  }



  ///获取当前用户的详细信息
  static Future agencyuserMe() async {
    return await AmosHttp.client.get(URLConst.agencyuserMe);
  }

  ///获取当前用户是否绑定车辆
  static Future getuserBJ() async {
    return await AmosHttp.client.get(URLConst.getuserBJ);
  }

  /// 持续上传当前地址
  static Future addESCar(Object data) async {
    return await AmosHttp.client.post(URLConst.addESCar, data: data);
  }


  ///根据amos userid获取单位
  static Future getUserCompany(String userId) async {
    return await AmosHttp.client.get(URLConst.userCompany + userId);
  }

  ///根据单位id获取单位人员列表
  static Future getCompanyPerson(String companyId) async {
    return await AmosHttp.client.get(URLConst.companyPerson + companyId + '/person');
  }

  ///当前用户指定菜单下的所有按钮map
  static Future privilegeButton(dynamic query) async {
    return await AmosHttp.client.get(URLConst.privilegeButton, query: query, contentType: ContentType.MULTIPART_FORM_DATA);
  }

  ///文件上传
  static Future fileStorage(FormData formData) async {
    return await AmosHttp.client.post(URLConst.fileStorage, data: formData, contentType: ContentType.MULTIPART_FORM_DATA);
  }

  ///批量文件上传
  static Future fileStorageBatch(FormData formData) async {
    return await AmosHttp.client.post(URLConst.fileStorageBatch, data: formData, contentType: ContentType.MULTIPART_FORM_DATA);
  }

  ///字典
  static Future dictionary(String key) async {
    return await AmosHttp.client.get(URLConst.dictionary + key + '/values', contentType: ContentType.FORM_URL_ENCODED);
  }

  ///首页消息列表
  static Future msgList(dynamic query) async {
    return await AmosHttp.client.get(URLConst.msgList, query: query, contentType: ContentType.FORM_URL_ENCODED);
  }

  ///首页菜单列表
  static Future warpGroupMe() async {
    return await AmosHttp.client.get(URLConst.warpGroupMe);
  }

  ///首页统计
  static Future getAlarmGiveStatistics() async {
    return await AmosHttp.client.get(URLConst.getAlarmGiveStatistics);
  }

  ///------------------------------------------------home---------------------------------------------------

  /// 首页统计
  static Future homeStatisticsAction() async {
    return await AmosHttp.client.get(URLConst.homeStatistics, contentType: ContentType.FORM_URL_ENCODED);
  }

  /// 物联监测统计
  static Future getFireAndDutyAndIOT() async {
    return await AmosHttp.client.get(URLConst.getFireAndDutyAndIOT, contentType: ContentType.FORM_URL_ENCODED);
  }

  /// 防火监督待办统计
  static Future countWaitingTaskByUser(String userId) async {
    return await AmosHttp.client
        .get(URLConst.countWaitingTaskByUser, query: {'userId': userId}, contentType: ContentType.FORM_URL_ENCODED);
  }

  /// 消防巡检待办统计
  static Future queryPlanTaskCount() async {
    return await AmosHttp.client.post(URLConst.queryPlanTaskCount, contentType: ContentType.FORM_URL_ENCODED);
  }

  /// 接处警待办统计
  static Future countUserCarExecuting() async {
    return await AmosHttp.client.get(URLConst.countUserCarExecuting, contentType: ContentType.FORM_URL_ENCODED);
  }

  /// 待办任务数统计
  static Future countPendingTask() async {
    return await AmosHttp.client.get(URLConst.countPendingTask, contentType: ContentType.FORM_URL_ENCODED);
  }

  /// 通过AmosId获取jcs消防员详细信息
  static Future getFirefightersByAmosId() async {
    return await AmosHttp.client.get(URLConst.getFirefightersByAmosId, contentType: ContentType.FORM_URL_ENCODED);
  }

  /// 通过AmosId获取jcs人员ID
  static Future getJcsUserByAmosId(String userId) async {
    return await AmosHttp.client
        .get(URLConst.getJcsUserByAmosId + '/$userId/userInfo', contentType: ContentType.FORM_URL_ENCODED);
  }

  /// 通过AmosId获取jcs人员ID
  static Future getJcsUserDetail(String userId) async {
    return await AmosHttp.client.get(URLConst.getJcsUserDetail + '/$userId', contentType: ContentType.FORM_URL_ENCODED);
  }

  ///------------------------------------------------故障报修---------------------------------------------------
  ///报修清单状态枚举
  static Future failureDetailsListStatus() async {
    return await AmosHttp.client.get(URLConst.failureDetailsListStatus, contentType: ContentType.FORM_URL_ENCODED);
  }

  ///报修清单全部列表
  static Future failureDetailsList() async {
    return await AmosHttp.client.get(URLConst.failureDetailsList, contentType: ContentType.FORM_URL_ENCODED);
  }

  ///报修清单列表统计
  static Future failureDetailsListCount(int type, Map<String, String> filterData) async {
    Map<String, dynamic> query = {'type': type}..addAll(filterData);
    return await AmosHttp.client.get(URLConst.failureDetailsListCount, query: query, contentType: ContentType.FORM_URL_ENCODED);
  }

  ///报修清单操作权限
  static Future failureDetailsExecuteTaskAuthButton(String sequenceNbr) async {
    return await AmosHttp.client
        .get(URLConst.failureDetailsExecuteTaskAuthButton + sequenceNbr.toString(), contentType: ContentType.FORM_URL_ENCODED);
  }

  ///报修清单分页列表
  static Future failureDetailsPage(int current, int size, int type, Map<String, String> filterData) async {
    Map<String, dynamic> query = {'current': current, 'size': size, 'type': type}..addAll(filterData);
    return await AmosHttp.client.get(URLConst.failureDetailsPage, query: query, contentType: ContentType.FORM_URL_ENCODED);
  }

  ///根据主键查询报修清单
  static Future failureDetails(String sequenceNbr) async {
    return await AmosHttp.client.get(URLConst.failureDetails + sequenceNbr.toString(), contentType: ContentType.FORM_URL_ENCODED);
  }

  ///新增报修
  static Future failureDetailsSave(Object data) async {
    return await AmosHttp.client.post(URLConst.failureDetailsSave, data: data);
  }

  ///根据主键查询审核记录
  static Future failureAudit(String sequenceNbr) async {
    return await AmosHttp.client.get(URLConst.failureAudit + sequenceNbr.toString(), contentType: ContentType.FORM_URL_ENCODED);
  }

  ///新增审核
  static Future failureAuditSave(Object data) async {
    return await AmosHttp.client.post(URLConst.failureAuditSave, data: data);
  }

  ///根据主键查询维修记录
  static Future failureMaintain(String sequenceNbr) async {
    return await AmosHttp.client
        .get(URLConst.failureMaintain + sequenceNbr.toString(), contentType: ContentType.FORM_URL_ENCODED);
  }

  ///新增维修
  static Future failureMaintainSave(Object data) async {
    return await AmosHttp.client.post(URLConst.failureMaintainSave, data: data);
  }

  ///报修日志
  static Future failureRepairLog(String sequenceNbr) async {
    return await AmosHttp.client.get(URLConst.failureRepairLog + sequenceNbr);
  }

  ///流程信息
  static Future failureDetailsProcessHistory(String sequenceNbr) async {
    return await AmosHttp.client.get(URLConst.failureDetailsProcessHistory, query: {'sequenceNbr': sequenceNbr});
  }

  ///当前流程
  static Future failureDetailsGetCurrentTask(String sequenceNbr) async {
    return await AmosHttp.client.get(
      URLConst.failureDetailsGetCurrentTask + sequenceNbr,
    );
  }

  ///验收操作
  static Future failureMaintainVerify(Object data) async {
    return await AmosHttp.client.post(URLConst.failureMaintainVerify, data: data);
  }

  ///根据主键查询验收记录
  static Future failureVerifyRecord(String sequenceNbr) async {
    return await AmosHttp.client.get(URLConst.failureVerify + sequenceNbr.toString(), contentType: ContentType.FORM_URL_ENCODED);
  }

  ///照片/视频上传
  static Future uploadFile(ChooseFileInfo element, List attachment) async {
    var name = element.file.path.substring(element.file.path.lastIndexOf('/') + 1, element.file.path.length);
    var formData = await MultipartFile.fromFile(element.file.path, filename: name);
    var fileUploadResult = await API.fileStorage(FormData.fromMap({'file': formData}));
    if (fileUploadResult != null) {
      var result = fileUploadResult;
      if (result.isNotEmpty) {
        attachment.add({
          'fileCategory': element.isPhoto ? FileType.IMAGE : FileType.VIDEO,
          'fileName': name,
          'filePath': result.keys.first,
        });
      }
    }
  }

  ///照片/视频上传
  static Future<void> uploadImg(ChooseFileInfo item, callback) async {
    var name = item.file.path.substring(item.file.path.lastIndexOf('/') + 1, item.file.path.length);
    var formData = await MultipartFile.fromFile(item.file.path, filename: name);
    var fileUploadResult = await API.fileStorage(FormData.fromMap({'file': formData}));
    callback(fileUploadResult.keys.first);
  }

  ///------------------------------------------------消防维保---------------------------------------------------
  ///按照amos账号查询人员归属信息（维保人员还是机场人员）
  static Future userIdentify() async {
    return await AmosHttp.client.get(URLConst.userIdentify);
  }

  ///按照任务详情id，查询是否可以提交
  static Future inquirePoint(String planTaskDetailId) async {
    return await AmosHttp.client.get(URLConst.inquirePoint + planTaskDetailId);
  }

  ///维保任务分页列表
  static Future queryPlanTask(dynamic data) async {
    return await AmosHttp.client.get(URLConst.queryPlanTask, query: data, contentType: ContentType.FORM_URL_ENCODED);
  }

  ///维保计划完成状态
  static Future equipmentFinishStatusList() async {
    return await AmosHttp.client.get(URLConst.planFinishStatusList);
  }

  ///维保任务排序条件
  static Future orderByList() async {
    return await AmosHttp.client.get(URLConst.orderByList);
  }

  ///维保人员列表
  static Future maintenanceUser() async {
    return await AmosHttp.client.get(URLConst.maintenanceUser);
  }

  ///业主单位列表
  static Future maintenanceCompany(dynamic data) async {
    return await AmosHttp.client.get(URLConst.maintenanceCompany, query: data);
  }

  ///维保设施移动端业主单位下拉列表
  static Future selectOwnerUnitList(dynamic data) async {
    return await AmosHttp.client.get(URLConst.selectOwnerUnitList, query: data);
  }

  ///维保设施列表
  static Future planTaskPoint(String id, dynamic data) async {
    return await AmosHttp.client
        .get(URLConst.planTaskPoint + id + '/list', query: data, contentType: ContentType.FORM_URL_ENCODED);
  }

  ///维保设施完成状态
  static Future planFinishStatusList() async {
    return await AmosHttp.client.get(URLConst.equipmentFinishStatusList);
  }

  ///建筑二级列表
  static Future buildingTree() async {
    return await AmosHttp.client.get(URLConst.buildingTierTree);
  }

  ///消防系统列表
  static Future fireFightSysPage(dynamic data) async {
    return await AmosHttp.client.get(URLConst.fireFightSysPage, query: data);
  }

  ///维保设施检查详情
  static Future taskPointDetail(dynamic data) async {
    return await AmosHttp.client.get(URLConst.taskPointDetail, query: data, contentType: ContentType.FORM_URL_ENCODED);
  }

  ///维保项合格校验
  static Future checkItemIsOk(dynamic data) async {
    return await AmosHttp.client.get(URLConst.checkItemIsOk, query: data, contentType: ContentType.FORM_URL_ENCODED);
  }

  ///维保数据提交
  static Future checkSaveRecord(dynamic data) async {
    return await AmosHttp.client.post(URLConst.checkSaveRecord, data: data, contentType: ContentType.JSON);
  }

  ///消防系统下的装备列表
  static Future fireFacilityPage(dynamic data) async {
    return await AmosHttp.client.get(URLConst.fireFacilityPage, query: data, contentType: ContentType.FORM_URL_ENCODED);
  }

  ///装备下的为维保设施列表
  static Future getFireFacilityPage(dynamic data) async {
    return await AmosHttp.client.get(URLConst.getFireFacilityPage, query: data, contentType: ContentType.FORM_URL_ENCODED);
  }

  ///装备详情
  static Future equipEquipmentDetail(String qrCode) async {
    return await AmosHttp.client
        .get(URLConst.equipEquipmentDetail, query: {'qrCode': qrCode}, contentType: ContentType.FORM_URL_ENCODED);
  }

  ///水源详情
  static Future waterResource(String id) async {
    return await AmosHttp.client.get(URLConst.waterResource + id, contentType: ContentType.FORM_URL_ENCODED);
  }

  ///维保记录列表
  static Future maintenanceRecord(dynamic data) async {
    return await AmosHttp.client.get(URLConst.maintenanceRecord, query: data, contentType: ContentType.FORM_URL_ENCODED);
  }

  ///维保记录详情
  static Future maintenanceRecordDetail(String id) async {
    return await AmosHttp.client
        .get(URLConst.maintenanceRecordDetail + id + '/detail', contentType: ContentType.FORM_URL_ENCODED);
  }

  ///维保记录排序条件
  static Future maintenanceRecordSort() async {
    return await AmosHttp.client.get(URLConst.maintenanceRecordSort, contentType: ContentType.FORM_URL_ENCODED);
  }

  ///维保检查结果下拉列表
  static Future maintenanceRecordStatus() async {
    return await AmosHttp.client.get(URLConst.maintenanceRecordStatus, contentType: ContentType.FORM_URL_ENCODED);
  }

  ///维保日历统计
  static Future maintenanceRecordCalendar(String date) async {
    return await AmosHttp.client
        .get(URLConst.maintenanceRecordCalendar + date + '/checkCalendar', contentType: ContentType.FORM_URL_ENCODED);
  }

  ///------------------------------------------------防火监督---------------------------------------------------
  ///按照amos账号查询人员归属信息
  static Future supervisionUserIdentify() async {
    return await AmosHttp.client.get(URLConst.supervisionUserIdentify);
  }

  ///计划检查列表
  static Future supervisionQueryPlanTask(dynamic data) async {
    return await AmosHttp.client.get(URLConst.supervisionQueryPlanTask, query: data, contentType: ContentType.FORM_URL_ENCODED);
  }

  ///检查计划任务状态
  static Future supervisionPlanTaskFinishStatus() async {
    return await AmosHttp.client.get(URLConst.supervisionPlanTaskFinishStatus, contentType: ContentType.FORM_URL_ENCODED);
  }

  ///检查计划检查类型
  static Future supervisionPlanTaskCheckType() async {
    return await AmosHttp.client.get(URLConst.supervisionPlanTaskCheckType, contentType: ContentType.FORM_URL_ENCODED);
  }

  ///检查计划排序条件
  static Future supervisionPlanTaskOrderBy() async {
    return await AmosHttp.client.get(URLConst.supervisionPlanTaskOrderBy, contentType: ContentType.FORM_URL_ENCODED);
  }

  ///检查点列表
  static Future supervisionQueryPlanTaskDetail(dynamic data) async {
    return await AmosHttp.client
        .get(URLConst.supervisionQueryPlanTaskDetail, query: data, contentType: ContentType.FORM_URL_ENCODED);
  }

  ///检查点状态
  static Future supervisionPlanTaskDetailIsStatus() async {
    return await AmosHttp.client.get(URLConst.supervisionPlanTaskDetailIsStatus, contentType: ContentType.FORM_URL_ENCODED);
  }

  ///检查人员
  static Future jcsOrgUsrListPerson() async {
    return await AmosHttp.client
        .get(URLConst.jcsOrgUsrList, query: {'bizOrgType': 'PERSON'}, contentType: ContentType.FORM_URL_ENCODED);
  }

  ///被检查单位
  static Future jcsOrgUsrListCompany() async {
    return await AmosHttp.client
        .get(URLConst.jcsOrgUsrList, query: {'bizOrgType': 'COMPANY'}, contentType: ContentType.FORM_URL_ENCODED);
  }

  ///陪同检查人
  static Future accompanyJcsOrgUsrList(String originalId) async {
    return await AmosHttp.client
        .get(URLConst.accompanyJcsOrgUsrList + '/$originalId' + '/person/list', contentType: ContentType.FORM_URL_ENCODED);
  }

  ///检查项
  static Future supervisionPointDetailItem(dynamic query) async {
    return await AmosHttp.client
        .get(URLConst.supervisionPointDetailItem, query: query, contentType: ContentType.FORM_URL_ENCODED);
  }

  ///检查项提交
  static Future supervisionPointDetailItemCommit(dynamic data) async {
    return await AmosHttp.client.post(URLConst.supervisionPointDetailItemCommit, data: data, contentType: ContentType.JSON);
  }

  ///------------------------------------------------隐患复查---------------------------------------------------
  ///隐患上报消防建筑树
  static Future equipBuildingTree() async {
    return await AmosHttp.client.get(URLConst.equipBuildingTree, contentType: ContentType.FORM_URL_ENCODED);
  }

  ///隐患上报隐患等级
  static Future dangerDangerLevel() async {
    return await AmosHttp.client.get(URLConst.dangerDangerLevel, contentType: ContentType.FORM_URL_ENCODED);
  }

  ///隐患上报整改方式
  static Future dangerGovernance() async {
    return await AmosHttp.client.get(URLConst.dangerGovernance, contentType: ContentType.FORM_URL_ENCODED);
  }

  ///隐患列表
  static Future dangerAuditList(dynamic data) async {
    return await AmosHttp.client.post(URLConst.dangerReviewList, data: data, contentType: ContentType.JSON);
  }

  ///隐患审核详情/隐患复查详情
  static Future dangerDetail(String dangerId) async {
    return await AmosHttp.client
        .get(URLConst.dangerDetail, query: {'dangerId': dangerId}, contentType: ContentType.FORM_URL_ENCODED);
  }

  ///隐患状态
  static Future dangerState() async {
    return await AmosHttp.client.get(URLConst.dangerState, contentType: ContentType.JSON);
  }

  ///隐患等级
  static Future dangerLevel() async {
    return await AmosHttp.client.get(URLConst.dangerLevel, contentType: ContentType.JSON);
  }

  ///隐患审核提交/隐患复查提交
  static Future dangerAudit(int executeType, dynamic data) async {
    return await AmosHttp.client
        .post(URLConst.dangerAudit + '?executeType=$executeType', data: data, contentType: ContentType.JSON);
  }

  ///计划列表
  static Future queryPlanList() async {
    return await AmosHttp.client.get(URLConst.queryPlanList);
  }

  ///巡检隐患列表
  static Future hiddenDangerList(dynamic data) async {
    return await AmosHttp.client.post(ApiAddress.HIDDEN_DANGER_LIST, data: data, contentType: ContentType.JSON);
  }

  ///------------------------------------------------实时监测---------------------------------------------------
  ///警情分页查询
  static Future getAlarmPage(param) async {
    return await AmosHttp.client.get(URLConst.alarmPage, query: param);
  }

  ///警情详情查询
  static Future getAlarmDetailsById(id) async {
    dynamic param = {
      'alamId': id,
      'equipId': '',
      'type': '',
      'area': false,
    };
    return await AmosHttp.client.get(URLConst.alarmDetailsByIdUrl, query: param);
  }

  ///建筑树查询
  static Future getBuildTree(String parentId) async {
    return await AmosHttp.client.get('${URLConst.buildTree}/$parentId');
  }

  ///查询设备列表
  static Future getIOTEquipmentTree(queryParam) async {
    return await AmosHttp.client.get('${URLConst.iotEquipment}', query: queryParam);
  }

  /// 消防系统
  static Future getFireSystem() async {
    return await AmosHttp.client.get('${URLConst.fireSystem}');
  }

  /// 获取设备详情
  static Future getEquipmentDetail(String id) async {
    return await AmosHttp.client.get('${URLConst.equipmentDetail}', query: {'qrCode': id});
  }

  /// 确认警情
  static Future confirmAlam(ConfirmAlam confirmAlam) async {
    return await AmosHttp.client.post('${URLConst.confirmAlam}', data: confirmAlam.toJson());
  }

  /// 获取部门人员
  static Future getDeptUser(String id) async {
    return await AmosHttp.client.get('${URLConst.deptUser}${id}');
  }

  /// 联动力量
  static Future taskSquadronList(id) async {
    return await AmosHttp.client.get('${URLConst.taskSquadron}${id}');
  }

  /// 查询警情详细信息
  static Future getJingqing(String id) async {
    return await AmosHttp.client.get('${URLConst.jingqing}/${id}');
  }

  /// 查询警情详细信息
  static Future getHazardousChemicals(query) async {
    return await AmosHttp.client.get('${URLConst.hazardousChemicals}', query: query);
  }

  /// 查询警情详细信息
  static Future getBuildingTree() async {
    return await AmosHttp.client.get('${URLConst.buildingTierTree}');
  }

  /// 根据警情id查询力量调派列表
  static Future getTransferList(query) async {
    return await AmosHttp.client.get('${URLConst.transferList}', query: query);
  }

  /// 根据警情id查询力量调派资源统计
  static Future getTransferstatistics(query) async {
    return await AmosHttp.client.get('${URLConst.transferstatistics}', query: query);
  }

  ///------------------------------------------------实战指挥---------------------------------------------------
  /// 根据警情id查询警情详情
  static Future getAlarmDetails(String id) async {
    return await AmosHttp.client.get('${URLConst.alarmDetailsUrl}/$id');
  }

  /// 警情列表
  static Future getAlarmList(int current, int size) async {
    Map<String, dynamic> query = {'current': current, 'size': size};
    return await AmosHttp.client.get(URLConst.alarmListUrl, query: query, contentType: ContentType.FORM_URL_ENCODED);
  }

  /// 根据警情id查询灾情统计
  static Future getAlarmPersonCount(String id) async {
    return await AmosHttp.client.get('${URLConst.alarmPersonCountUrl}/$id');
  }

  /// 根据警情id查询救援对象
  static Future getAlarmRescueObject(String id) async {
    return await AmosHttp.client.get('${URLConst.alarmRescueObjectUrl}?alertId=$id');
  }

  /// 根据警情id查询到场力量统计
  static Future getAlarmStrengthCount(String id) async {
    return await AmosHttp.client.get('${URLConst.alarmStrengthCountUrl}/$id');
  }

  /// 警情任务反馈
  static Future alarmTaskFeedback(Object data) async {
    return await AmosHttp.client.post('${URLConst.alarmTaskFeedbackUrl}', data: data);
  }

  /// 警情任务反馈记录查询
  static Future alarmlistByAlertId(String id) async {
    return await AmosHttp.client.get('${URLConst.alarmlistByAlertId}?alertCalledId=$id');
  }


  /// 更新车辆状态
  static Future updateCarStatus(String carId, String carStatus) async {
    return await AmosHttp.client.put('${URLConst.updateCarStatusUrl}?carId=$carId&carStatus=$carStatus');
  }

  /// 车辆状态列表
  static Future getCarStatusList() async {
    return await AmosHttp.client.get('${URLConst.carStatusListUrl}');
  }

  /// 车辆人员岗位信息
  static Future carPersonPost() async {
    return await AmosHttp.client.get('${URLConst.personPostUrl}');
  }

  ///在岗监测分页查询
  static Future getMonitorEventPage(param) async {
    return await AmosHttp.client.get(URLConst.monitorEventPage, query: param);
  }

  /// 在岗监测确认事件
  static Future confirmMonitorEvent(MonitorEvent monitorEvent) async {
    return await AmosHttp.client.put('${URLConst.confirmMonitorEvent}/${monitorEvent.id}', data: monitorEvent.toJson());
  }

  /// 视频监控列表
  static Future equipMonitorVideoList(int current, int size) async {
    Map<String, dynamic> query = {'current': current, 'size': size};
    return await AmosHttp.client.post(URLConst.monitorVideoListUrl, data: query);
  }

  /// 车辆绑定列表
  static Future equipmentCarList(dynamic query) async {
    return await AmosHttp.client.get(URLConst.equipmentCarList, query: query);
  }

  /// 车辆绑定/解绑操作
  static Future adduserCar(String type, dynamic data) async {
    return await AmosHttp.client.post(URLConst.adduserCar + '/$type', data: data);
  }

  /// 车辆分类
  static Future commandTree() async {
    return await AmosHttp.client.get(URLConst.commandTree);
  }

  /// 联动信息列表
  static Future linkageUnitPage(dynamic query) async {
    return await AmosHttp.client.get(URLConst.linkageUnitPage, query: query);
  }

  /// 联动信息服务类型
  static Future gwmcDataDictionaryLDDWLB() async {
    return await AmosHttp.client.get(URLConst.gwmcDataDictionaryLDDWLB);
  }

  /// 联动信息联动单位
  static Future gwmcDataDictionaryYJLDDW() async {
    return await AmosHttp.client.get(URLConst.gwmcDataDictionaryYJLDDW);
  }

  /// 警情列表
  static Future commandHistoryList(dynamic data) async {
    return await AmosHttp.client.get(URLConst.commandHistoryList, query: data);
  }

  /// 警情类型
  static Future gwmcDataDictionaryJQLB() async {
    return await AmosHttp.client.get(URLConst.gwmcDataDictionaryJQLB);
  }

  /// 车辆状态
  static Future gwmcDataDictionaryCARSTATE() async {
    return await AmosHttp.client.get(URLConst.gwmcDataDictionaryCARSTATE);
  }

  /// 获取绑定的车辆
  static Future getAlertCalledId() async {
    return await AmosHttp.client.get(URLConst.getAlertCalledId);
  }

  /// 获取当前执行的灾情
  static Future getAlertCalledData() async {
    return await AmosHttp.client.get(URLConst.getAlertCalledData);
  }

  /// 获取车辆/任务当前状态
  /// [carId] 绑定的车辆ID
  /// [alertCalledId] 加入的灾情ID
  static Future getCurrentCarOrTaskState(String carId, String alertCalledId) async {
    return await AmosHttp.client.get('${URLConst.getCurrentCarOrTaskState}/$carId/$alertCalledId');
  }

  /// 获取任务反馈
  /// [carId] 绑定的车辆ID
  /// [alertCalledId] 加入的灾情ID
  static Future getTaskFeedback(String carId, String alertCalledId) async {
    return await AmosHttp.client.get('${URLConst.getTaskFeedback}/$carId/$alertCalledId');
  }

  /// 修改车辆/任务当前状态
  /// [carId] 绑定的车辆ID
  /// [alertCalledId] 加入的灾情ID
  /// [code] 车辆状态修改为（状态id） 任务状态为已完成等于’finished‘,执行中等于‘executing’
  /// [type] 类型  车辆1 任务2
  /// [photoUrls] 现场图片

  static Future setCurrentCarOrTaskState(String carId, String alertCalledId, String code, String type, {List attachment , String remarks}) async {
    return await AmosHttp.client.post(URLConst.setCurrentCarOrTaskState,
        data: {'carid': carId, 'alertCalledId': alertCalledId, 'code': code, 'type': type,'photos':attachment, 'remarks': remarks ?? ''});
  }

  /// 获取救援预案
  static Future getSituation(String id) async {
    return await AmosHttp.client.get(URLConst.getSituation, query: {'id': id});
  }

  /// 获取指令流
  static Future getCommandFlow(String id) async {
    return await AmosHttp.client.get(URLConst.getCommandFlow + '/$id');
  }

  /// 获取力量信息
  static Future getPowerInfo(String id) async {
    return await AmosHttp.client.get(URLConst.getPowerInfo + '/$id');
  }

  /// 获取救援对象
  static Future getOrgUsrzhDto(String id) async {
    return await AmosHttp.client.get(URLConst.getOrgUsrzhDto + '/$id');
  }

  /// 获取重点部位树
  static Future getKeySiteBuildTree(String id) async {
    return await AmosHttp.client.get(URLConst.getBuildTree + '/$id');
  }

  /// 获取重点部位
  static Future getkeySite(String id) async {
    return await AmosHttp.client.get(URLConst.getkeySite + '/$id');
  }

  /// 当前隐患统计
  static Future unFinishedDanger() async {
    return await AmosHttp.client.get(URLConst.unFinishedDanger);
  }

  /// 巡检隐患列表
  static Future patrolHiddenDangerList(dynamic data) async {
    return await AmosHttp.client.post(URLConst.hiddenDangerList, data: data);
  }

  /// 获取所有人员
  static Future patrolAllPersonList() async {
    return await AmosHttp.client.get(URLConst.hiddenPersonList);
  }

  /// 添加缺陷
  static Future defectAdd(dynamic data) async {
    return await AmosHttp.client.post(URLConst.defectAdd, data: data);
  }

  /// 获取当前登录人待处置任务及预案信息
  static Future getUserOperateCountAndPlanName() async {
    return await AmosHttp.client.get(URLConst.getUserOperateCountAndPlanName);
  }

  /// 获取当前登录人预案相关任务列表
  static Future selectTaskActionPage(String batchNo, String dataType, int current, int size) async {
    return await AmosHttp.client.get(URLConst.selectTaskActionPage, query: {'batchNo': batchNo, 'dataType': dataType, 'current': current,'size': size,});
  }

  ///获取当前登录人预案步骤时间轴
  static Future getPlanStep(String batchNo) async {
    return await AmosHttp.client.get(URLConst.getPlanStep, query: {'batchNo': batchNo });
  }

  /// 待处置任务当前任务
  static Future selectDisposalActionList(String batchNo,String dataType) async {
    return await AmosHttp.client.get(URLConst.selectDisposalActionList, query: {'batchNo': batchNo,'dataType': dataType,});
  }

  /// 处置记录
  static Future selectDisposalListPage(int current,int size) async {
    return await AmosHttp.client.get(URLConst.selectDisposalListPage, query: {'current': current,'size': size,});
  }

  /// 待处置任务当前任务带分页
  static Future selectDisposalActionPage(String batchNo,String dataType,int current,int size) async {
    return await AmosHttp.client.get(URLConst.selectDisposalActionPage, query: {'batchNo': batchNo,'dataType': dataType,'current': current,'size': size,});
  }

  /// 待处置任务---任务详情--预案信息
  static Future selectDisposalDetails(String batchNo) async {
    return await AmosHttp.client.get(URLConst.selectDisposalDetails, query: {'batchNo': batchNo});
  }

  /// 预案流程步骤
  static Future getPlaneRecordByNew(String batchNo) async {
    return await AmosHttp.client.get(URLConst.getPlaneRecordByNew, query: {'batchNo': batchNo,'pageNum': 1, 'size': 20,});
  }


  /// 共用
  static Future shareApi(String urlString, {Map data}) async {
    // String queryString ='';
    // data.forEach((k, v) {
    //   queryString = '$queryString$k=$v&';
    // });
    return await AmosHttp.client.post(urlString, data: data);
  }

  /// 发送预案信息
  static Future replyMessage(dynamic data) async {
    return await AmosHttp.client.post(URLConst.replyMessage, data: data);
  }
  /// 预案更新状态
  static Future updateStatusById(String id, bool runStatus) async {
    return await AmosHttp.client.post(URLConst.updateStatusById+'?id=$id&runStatus=$runStatus');
  }

  ///------------------------------------------------任务执行---------------------------------------------------

  /// 任务执行列表
  static Future pendingTaskList(String status, int current, int size) async {
    return await AmosHttp.client.get(URLConst.pendingTaskList + '?status=$status&current=$current&size=$size');
  }

  /// 任务执行流程
  static Future getTaskFlowLogs(String id) async {
    return await AmosHttp.client.get(URLConst.getTaskFlowLogs + '/$id');
  }

  /// 动态表单结构
  static Future getDynamicFormStructure(int id) async {
    return await AmosHttp.client.get(URLConst.getDynamicFormStructure + '/$id');
  }

  /// 动态表单结构
  static Future getDynamicFormData(String taskId) async {
    return await AmosHttp.client.get(URLConst.getDynamicFormData + '?flowTaskId=' + taskId);
  }

  /// 动态选择列表
  static Future getDynamicSelectList(String url) async {
    return await AmosHttp.client.get(url);
  }
  static Future postDynamicSelectList(String url, Map data) async {
    return await AmosHttp.client.post(url, data: data);
  }

  /// 动态表单提交
  static Future submitDynamicFormData(String url, String method, Map<String, dynamic> data) async {
    return method == 'POST'
        ? await AmosHttp.client.post(url, data: data)
        : await AmosHttp.client.get(url);
  }

  /// 维保任务列表
  static Future maintGetWorkPage(String status, int current, int size, String userId) async {
    return await AmosHttp.client.get(URLConst.maintGetWorkPage + '?status=$status&current=$current&size=$size&userId=$userId');
  }

  /// 维保任务列表
  static Future maintGetFacilityByWorkId(String workId) async {
    return await AmosHttp.client.get(URLConst.maintGetFacilityByWorkId + '?workId=$workId');
  }

  /// 维保任务列表
  static Future maintGetDetailByWorkId(String workId,String fireFacilities) async {
    return await AmosHttp.client.get(URLConst.maintGetDetailByWorkId + '?workId=$workId&fireFacilities=$fireFacilities');
  }
}
