/// 获取缓存数据
///
import 'package:amos_iot_login_tpl/amos_iot_login_tpl.dart';



/// http config cache
class HTTPConfigCache {
  static String _baseURL;
  static String _updateApkURL;

  /// 获取 baseUrl
  static Future<String> getGatewayUrl() async {
    if (_baseURL == null) {
      String url = await APIUrlManager.getGatewayUrl();
      _baseURL = url;
    }
    return _baseURL;
  }

  /// 获取 app 升级地址
  static Future<String> getUpdateApkUrl() async {
    if (_updateApkURL == null) {
      String url = await APIUrlManager.getUpdateApkUrl();
      _updateApkURL = url;
    }
    return _updateApkURL;
  }

  /// 清除内存缓存的url
  /// 更改服务地址后需要调用此方法清除
  static void clearCacheUrl() {
    _baseURL = null;
    _updateApkURL = null;
  }
}
