import 'package:intl/intl.dart';

class TimeUtils {
  static String longFormat = 'yyyy-MM-dd HH:mm:ss';
  static String longFormatN = 'yyyy-MM-dd';

  ///获取现在的时间
  static String getDayNow() {
    var nowTime = DateTime.now();
    return nowTime.toString();
  }

  ///获取今天的开始时间
  static String getDayBegin() {
    var nowTime = DateTime.now();
    var day = DateTime(nowTime.year, nowTime.month, nowTime.day, 0, 0, 0);
    return DateFormat(longFormat).format(day).toString();
  }

  ///获取今天的开始时间
  static String getDayBeginN() {
    var nowTime = DateTime.now();
    var day = DateTime(nowTime.year, nowTime.month, nowTime.day, 0, 0, 0);
    return DateFormat(longFormatN).format(day).toString();
  }

  ///获取今天的结束时间
  static String getDayEnd() {
    var nowTime = DateTime.now();
    var day = DateTime(nowTime.year, nowTime.month, nowTime.day, 23, 59, 59);
    return DateFormat(longFormat).format(day).toString();
  }

  ///获取昨天的开始时间
  static String getBeginDayOfYesterday() {
    var nowTime = DateTime.now();
    var yesterday = nowTime.add(const Duration(days: -1));
    var day = DateTime(yesterday.year, yesterday.month, yesterday.day, 0, 0, 0);
    return DateFormat(longFormat).format(day).toString();
  }

  ///获取明天的开始时间
  static String getBeginDayOfToMorrow() {
    var nowTime = DateTime.now();
    var yesterday = nowTime.add(const Duration(days: 1));
    var day = DateTime(yesterday.year, yesterday.month, yesterday.day, 0, 0, 0);
    return DateFormat(longFormatN).format(day).toString();
  }

  ///获取昨天的结束时间
  static String getEndDayOfYesterDay() {
    var nowTime = DateTime.now();
    var yesterday = nowTime.add(const Duration(days: -1));
    var day = DateTime(yesterday.year, yesterday.month, yesterday.day, 23, 59, 59);
    return DateFormat(longFormat).format(day).toString();
  }

  ///获取本周的开始时间
  static String getBeginDayOfWeek() {
    var nowTime = DateTime.now();
    var yesterday = nowTime.add(Duration(days: -(nowTime.weekday - 1)));
    var day = DateTime(yesterday.year, yesterday.month, yesterday.day, 0, 0, 0);
    return DateFormat(longFormat).format(day).toString();
  }

  ///获取本周的结束时间
  static String getEndDayOfWeek() {
    var nowTime = DateTime.now();
    var yesterday = nowTime.add(Duration(days: 7 - nowTime.weekday));
    var day = DateTime(yesterday.year, yesterday.month, yesterday.day, 23, 59, 59);
    return DateFormat(longFormat).format(day).toString();
  }

  ///获取上周的开始时间
  static String getBeginDayOfBeforeWeek() {
    var nowTime = DateTime.now();
    var yesterday = nowTime.add(Duration(days: -(6 + nowTime.weekday)));
    var day = DateTime(yesterday.year, yesterday.month, yesterday.day, 0, 0, 0);
    return DateFormat(longFormat).format(day).toString();
  }

  ///获取上周的结束时间
  static String getEndDayOfBeforeWeek() {
    var nowTime = DateTime.now();
    var yesterday = nowTime.add(Duration(days: -nowTime.weekday));
    var day = DateTime(yesterday.year, yesterday.month, yesterday.day, 23, 59, 59);
    return DateFormat(longFormat).format(day).toString();
  }

  ///获取本月的开始时间
  static String getBeginDayOfMonth() {
    var nowTime = DateTime.now();
    var day = DateTime(nowTime.year, nowTime.month, 1, 0, 0, 0);
    return DateFormat(longFormat).format(day).toString();
  }

  ///获取本月的结束时间
  static String getEndDayOfMonth() {
    var nowTime = DateTime.now();
    var nextMonthday = DateTime(nowTime.year, nowTime.month + 1, 1, 0, 0, 0);
    var endMonthDay = nextMonthday.add(const Duration(days: -1));
    var day = DateTime(endMonthDay.year, endMonthDay.month, endMonthDay.day, 23, 59, 59);
    return DateFormat(longFormat).format(day).toString();
  }

  ///获取上月的开始时间
  static String getBeginDayOfBeforeMonth() {
    var nowTime = DateTime.now();
    var day = DateTime(nowTime.year, nowTime.month - 1, 1, 0, 0, 0);
    return DateFormat(longFormat).format(day).toString();
  }

  ///获取上月的结束时间
  static String getEndDayOfBeforeMonth() {
    var nowTime = DateTime.now();
    var nowDay = DateTime(nowTime.year, nowTime.month, 1, 0, 0, 0);
    var endMonthDay = nowDay.add(const Duration(days: -1));
    var day = DateTime(endMonthDay.year, endMonthDay.month, endMonthDay.day, 23, 59, 59);
    return DateFormat(longFormat).format(day).toString();
  }
}
