import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:amos_iot_login_tpl/amos_iot_login_tpl.dart';
import 'package:amos_iot_login_tpl/utils/EventBusUtil.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:jcs_airport/services/api.dart';
import 'package:amos_flutter_utils/extension/int_extension.dart';
import '../../consts/http_config.dart';

///@Description     首页菜单卡片
///@author          helinlin
///@create          2021-11-17 13:46
class HomeMenuCard extends StatefulWidget {
  const HomeMenuCard({Key key}) : super(key: key);

  @override
  _HomeMenuCardState createState() => _HomeMenuCardState();
}

class _HomeMenuCardState extends State<HomeMenuCard> {
  final List<PlatformMenu> _menuList = <PlatformMenu>[];

  @override
  void initState() {
    super.initState();
    getMenuList();
  }

  @override
  Widget build(BuildContext context) {
    return CommonCard(
      margin: const EdgeInsets.symmetric(vertical: 8, horizontal: 12),
      child: Padding(
        padding: const EdgeInsets.all(8.0),
        child: Column(
          children: [
            GridView.builder(
              physics: const NeverScrollableScrollPhysics(),
              shrinkWrap: true,
              gridDelegate: const SliverGridDelegateWithFixedCrossAxisCount(crossAxisCount: 3, childAspectRatio: 1.0),
              //只显示8个
              itemCount: _menuList.length > 8 ? 8 : _menuList.length,
              itemBuilder: (BuildContext context, int index) {
                return index == 7
                    ? InkWell(
                        onTap: () => EventBusUtil.getInstance().fire(EventFn(1)),
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.center,
                          children: [
                            Opacity(
                                opacity: 0.6,
                                child: Transform.scale(
                                  scale: 1,
                                  child: Image.asset(
                                    'assets/icon/more_menu.png',
                                    width: 35.px,
                                  ),
                                )),
                            const SizedBox(
                              height: 10,
                            ),
                            Text(
                              '更多服务',
                              style: TextStyle(fontSize: 14.px),
                            ),
                          ],
                        ),
                      )
                    : InkWell(
                        onTap: () => Get.toNamed(_menuList[index].path, arguments: _menuList[index]),
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.center,
                          children: [
                            AmosImageIcon(image: _menuList[index].icon ?? GlobalImagePath.WB_DEFAULT, width: 35.px),
                            const SizedBox(
                              height: 10,
                            ),
                            Text(
                              _menuList[index].permissionName ?? '',
                              style: TextStyle(fontSize: 13.px),
                            )
                          ],
                        ),
                      );
              },
            ),
          ],
        ),
      ),
    );
  }

  ///获取菜单
  void getMenuList() {
    API.warpGroupMe().then((value) {
      if (value != null) {
        value.forEach((system) {
          if (system['warpGroupName'] == '配置管理系统') {
            setState(() {
              system['children'].forEach((menu) {
                PlatformMenu platformMenu = PlatformMenu.fromJson(menu);
                if (platformMenu.isWarp && platformMenu.icon != null && platformMenu.icon.isNotEmpty) {
                  platformMenu.icon = HttpConfig.GateWayURL  + platformMenu.icon;
                  _menuList.add(platformMenu);
                }
              });
            });
          }
        });
      }
    });
  }
}
