import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:amos_iot_login_tpl/message/message_list.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

///@Description     HomeWaitingCard
///@author          helinlin
///@create          2021-11-17 15:45
class HomeWaitingCard extends StatefulWidget {
  final Type type;

  const HomeWaitingCard({Key key, this.type}) : super(key: key);

  @override
  _HomeWaitingCardState createState() => _HomeWaitingCardState();
}

class _HomeWaitingCardState extends State<HomeWaitingCard> {
  @override
  Widget build(BuildContext context) {
    return CommonCard(
      child: Padding(
        padding: const EdgeInsets.only(right: 8, left: 8, top: 8),
        child: Column(
          children: [
            Row(
              children: [
                const Expanded(
                    child: Text(
                  '待办任务',
                  style: TextStyle(fontSize: 15),
                )),
                InkWell(
                  onTap: () => Get.to(MessageList(type: MessageType.Task)),
                  child: Opacity(
                      opacity: 0.6,
                      child: Row(
                        children: const [
                          Text(
                            '更多',
                            style: TextStyle(fontSize: 13),
                          ),
                          Icon(
                            Icons.chevron_right,
                            size: 18,
                          )
                        ],
                      )),
                )
              ],
            ),
            const Divider(
              color: Colors.black,
              height: 15,
              thickness: 0.1,
            ),
            ListView.builder(
              itemBuilder: (BuildContext context, int index) {
                return Column(
                  children: [
                    Row(
                      children: [
                        Padding(
                          padding: const EdgeInsets.only(left: 10, right: 20),
                          child: Image.asset(
                            'assets/images/car_default.png',
                            width: 32,
                          ),
                        ),
                        Expanded(
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              const Text('油区进油后明火作业'),
                              const SizedBox(
                                height: 4,
                              ),
                              Opacity(
                                opacity: 0.6,
                                child: Row(
                                  children: const [
                                    Expanded(
                                      child: Text(
                                        '技术经验',
                                        style: TextStyle(fontSize: 13),
                                        overflow: TextOverflow.ellipsis,
                                      ),
                                    ),
                                    Text(
                                      '2021-11-17 14:54:30',
                                      style: TextStyle(fontSize: 13),
                                      overflow: TextOverflow.ellipsis,
                                    ),
                                  ],
                                ),
                              )
                            ],
                          ),
                        )
                      ],
                    ),
                    const Divider(
                      color: Colors.black,
                      thickness: 0.1,
                    )
                  ],
                );
              },
              itemCount: 3,
              shrinkWrap: true,
              physics: const NeverScrollableScrollPhysics(),
            )
          ],
        ),
      ),
    );
  }
}
