import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:flutter/material.dart';

///@Description     WaitingTask备份，后续不再需要可以删除
///@author          helinlin
///@create          2021-11-17 16:19
class WaitingTask extends StatefulWidget {
  const WaitingTask({Key key}) : super(key: key);

  @override
  _WaitingTaskState createState() => _WaitingTaskState();
}

class _WaitingTaskState extends State<WaitingTask> {
  List<Map> data = [
    {'icon': '', 'title': '消防监督', 'time': '2021-11-18 10:47:21', 'content': '数据数据数据数据数据数据数据数据数据数据数据数据'},
    {'icon': '', 'title': '消防巡查', 'time': '2021-11-18 10:47:21', 'content': '数据数据数据数据数据数据数据数据数据数据数据数据'},
    {'icon': '', 'title': '接处警', 'time': '2021-11-18 10:47:21', 'content': '数据数据数据数据数据数据数据数据数据数据数据数据'},
  ];
  List<Map> type = [
    {'name': '全部'},
    {'name': '消防监督'},
    {'name': '消防巡查'},
    {'name': '接处警'},
  ];
  String typeValue = '全部';
  Divider divider = const Divider(
    color: Colors.black,
    thickness: 0.1,
  );

  @override
  Widget build(BuildContext context) {
    List<Map> filterData = [];
    if (typeValue == '全部') {
      filterData.addAll(data);
    } else {
      data.forEach((element) {
        if (element['title'] == typeValue) {
          filterData.add(element);
        }
      });
    }
    return Scaffold(
      appBar: AppBar(
        title: const Text('我的待办'),
      ),
      backgroundColor: const Color.fromARGB(255, 245, 250, 245),
      body: SingleChildScrollView(
        child: Column(
          children: [
            CommonCard(
              child: Row(
                children: <Widget>[
                  Expanded(
                    flex: 2,
                    child: Container(
                      height: 40,
                      margin: const EdgeInsets.only(left: 10, top: 10, right: 5, bottom: 10),
                      padding: const EdgeInsets.all(5),
                      decoration: BoxDecoration(
                          border: Border.all(color: Colors.black26, width: 1),
                          borderRadius: const BorderRadius.all(Radius.circular(6))),
                      child: DropdownButton<String>(
                        hint: const Text('请选择'),
                        isExpanded: true,
                        underline: Container(
                          height: 0,
                        ),
                        value: typeValue,
                        items: type
                            .map((t) => DropdownMenuItem<String>(
                                  child: Text(t['name']),
                                  value: t['name'],
                                ))
                            .toList(),
                        onChanged: (String value) {
                          setState(() {
                            typeValue = value;
                          });
                        },
                      ),
                    ),
                  ),
                  Expanded(
                    flex: 3,
                    child: Container(
                      height: 40,
                      margin: const EdgeInsets.only(left: 5, top: 10, right: 10, bottom: 10),
                      decoration: BoxDecoration(
                          border: Border.all(color: Colors.black26, width: 1),
                          borderRadius: const BorderRadius.all(Radius.circular(6))),
                      child: TextField(
                        autofocus: false,
                        decoration: const InputDecoration(
                            hintText: '搜索',
                            border: InputBorder.none,
                            contentPadding: EdgeInsets.only(left: 10, top: 10, right: 5, bottom: 10)),
                        onChanged: (String value) {},
                      ),
                    ),
                  )
                ],
              ),
            ),
            CommonCard(
              child: Padding(
                padding: const EdgeInsets.all(8.0),
                child: ListView.separated(
                  itemBuilder: (BuildContext context, int index) {
                    return InkWell(
                      onTap: () {
                        //Get.to(WaitingTaskDetail(type: filterData[index]['title']))
                      },
                      child: Row(
                        children: [
                          Image.asset('assets/images/car_default.png'),
                          const SizedBox(
                            width: 10,
                          ),
                          Expanded(
                            child: Column(
                              children: [
                                Row(
                                  children: [
                                    Expanded(
                                        child: Text(
                                      filterData[index]['title'],
                                      overflow: TextOverflow.ellipsis,
                                      style: const TextStyle(fontSize: 17),
                                    )),
                                    Text(filterData[index]['time']),
                                  ],
                                ),
                                const SizedBox(
                                  height: 4,
                                ),
                                Opacity(
                                  opacity: 0.8,
                                  child: Row(
                                    children: [
                                      Expanded(child: Text(filterData[index]['content'], overflow: TextOverflow.ellipsis)),
                                    ],
                                  ),
                                )
                              ],
                            ),
                          )
                        ],
                      ),
                    );
                  },
                  separatorBuilder: (BuildContext context, int index) => divider,
                  itemCount: filterData.length,
                  shrinkWrap: true,
                ),
              ),
            )
          ],
        ),
      ),
    );
  }
}
