import 'package:amos_flutter_ui/card/common_card.dart';
import 'package:amos_iot_login_tpl/amos_iot_login_tpl.dart';
import 'package:amos_iot_login_tpl/message/index.dart';
import 'package:amos_iot_login_tpl/utils/EventBusUtil.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:jcs_airport/services/api.dart';
import 'package:amap_flutter_location/amap_flutter_location.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:permission_handler_platform_interface/permission_handler_platform_interface.dart';
import 'package:permission_handler/permission_handler.dart';
import 'package:amap_flutter_location/amap_flutter_location.dart';
import 'package:amap_flutter_location/amap_location_option.dart';
import 'package:jcs_airport/view/workBench/fireproofSupervision/planCheck/add_hidden_danger.dart';
import 'HomeMenuCard.dart';
import 'HomeMessageCard.dart';
import 'dart:async';




///@Description     非领导首页
///@author          helinlin
///@create          2021-11-17 13:42
class HomeCommon extends StatefulWidget {
  const HomeCommon({Key key}) : super(key: key);

  @override
  _HomeCommonState createState() => _HomeCommonState();
}

class _HomeCommonState extends State<HomeCommon> {
  Map amosUser = {
    'companys': [{}]
  };




  @override
  void initState() {
    super.initState();

    agencyuserMe();


  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text('首页'),
        centerTitle: true,
      ),
      body: SingleChildScrollView(
        child: Container(
          color: const Color.fromARGB(255, 245, 250, 245),
          child: Stack(
            children: [
              Container(
                height: 300,
                decoration: const BoxDecoration(
                    gradient: LinearGradient(
                        begin: Alignment.topCenter, end: Alignment.bottomCenter, colors: [Colors.blue, Colors.blue])),
                child: Container(),
              ),
              Column(
                children: [
                  getPersonInfo(),
                  const HomeMenuCard()
                ],
              ),
            ],
          ),
        ),
      ),
    );
  }

  Widget getPersonInfo() {
    return Padding(
      padding: const EdgeInsets.all(25.0),
      child: Row(
        children: [
          Expanded(
            child: Container(
              height: 170,
              decoration: const BoxDecoration(
                  color: Colors.blueAccent,
                  borderRadius: BorderRadius.all(Radius.circular(20)),
                  boxShadow: <BoxShadow>[
                    BoxShadow(offset: Offset(2, 2), blurRadius: 15, color: Colors.lightBlue),
                  ]),
              child: Padding(
                padding: const EdgeInsets.all(10.0),
                child: Stack(
                  children: [
                    Positioned(
                      left: 10,
                      top: 10,
                      child: Text(
                        '${amosUser['realName'] ?? ''}',
                        style: const TextStyle(color: Colors.white),
                      ),
                    ),
                    Positioned(
                      left: 10,
                      bottom: 10,
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Text('${amosUser['mobile'] ?? ''}', style: const TextStyle(color: Colors.white, fontSize: 13)),
                          Text('${(amosUser['companys'][0] ?? [])['companyName'] ?? ''}',
                              style: const TextStyle(color: Colors.white, fontSize: 13)),
                        ],
                      ),
                    ),
                    Positioned(
                        right: 10,
                        top: 10,
                        child: Image.asset(
                                'assets/images/person_default.png',
                                height: 60,
                                fit: BoxFit.fill,
                              )
                           )
                  ],
                ),
              ),
            ),
          ),
        ],
      ),
    );
  }

  ///获取Amos用户详细信息
  Future<void> agencyuserMe() async {
    var result = await API.agencyuserMe();
    if (result == null) {
      return;
    }
    setState(() {
      amosUser.addAll(result);
    });

  }



}
