import 'package:amos_iot_login_tpl/amos_iot_login_tpl.dart';
import 'package:get/get.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:jcs_airport/services/api.dart';
import 'package:jcs_airport/view/common/base_choose_person.dart';
import 'package:shared_preferences/shared_preferences.dart';

///@Description     故障报修当前登录人所在部门下的人员选择
///@author          helinlin
///@create          2021-09-13 11:28
class ChoosePersonMalfunctionReport extends BaseChoose {
  ChoosePersonMalfunctionReport({Map person}) : super(person: person);

  @override
  BaseChooseState getBaseChoosePersonState() => _ChoosePersonMalfunctionReportState();
}

class _ChoosePersonMalfunctionReportState extends BaseChooseState {
  @override
  Future<void> getData() => initData();

  @override
  String getIdKey() => 'sequenceNbr';

  @override
  String getNameKey() => 'bizOrgName';

  ///jcs获取部门下人员列表
  Future<void> initData() async {
    Future.delayed(Duration.zero, () async {
      MsgBox.showProgressDialog(context, content: '加载中，请稍后...');
      SharedPreferences sp = await SharedPreferences.getInstance();
      var userInfo = await API.getUserCompany(sp.getString(GlobalConst.USER_ID));
      if (userInfo != null) {
        var data = await API.getCompanyPerson(userInfo);
        Get.back();
        if (data != null) {
          setState(() {
            data.forEach((element) {
              persons.addAll(element['persons']);
            });
          });
        }
      } else {
        Get.back();
      }
    });
  }
}
