import 'package:flutter/material.dart';
import 'package:jcs_airport/utils/convert_date.dart';
import 'package:jcs_airport/view/common/base_dropdown_filter.dart';

///@Description     带有[人员范围] [日期区间] [状态类型] [排序规则] Dropdown的基础页面
///@author          helinlin
///@create          2021-09-01 9:27
abstract class CommonDropdownFilterState<T extends StatefulWidget> extends BaseDropdownFilterState<T> {
  ///人员范围
  List<Map> scope = [
    {'title': '全部', 'value': ''},
  ];

  ///日期区间
  List<Map> date = [
    {'title': '全部时间'},
    {'title': '今天'},
    {'title': '昨天'},
    {'title': '本周'},
    {'title': '上周'},
    {'title': '本月'},
    {'title': '上月'},
  ];

  ///状态类型
  List<Map> status = [
    {'title': '所有状态', 'value': ''},
  ];

  ///排序规则
  List<Map> orderType = [
    {'title': '默认排序', 'value': ''},
  ];
  int scopeSelectIndex = 0;
  int dateSelectIndex = 0;
  int statusSelectIndex = 0;
  int orderTypeSelectIndex = 0;

  Map<String, Object> filterData = {};
  Map chooseDepartment = {};
  Map choosePerson = {};


  @override
  List<DropdownMenuBuilderEntity> getDropdownMenuContentEntity() {
   return <DropdownMenuBuilderEntity>[
     DropdownMenuBuilderEntity(scopeSelectIndex, scope),
     DropdownMenuBuilderEntity(dateSelectIndex, date),
     DropdownMenuBuilderEntity(statusSelectIndex, status),
     DropdownMenuBuilderEntity(orderTypeSelectIndex, orderType)
   ];
  }

  @override
  void onDropdownItemChanged({int menuIndex, int index, int subIndex, data}) {
    print('menuIndex:$menuIndex index:$index subIndex:$subIndex data:$data');
    switch (menuIndex) {
      case 0:
        if (data['value'] != '') {
          filterData['userId'] = data['value'];
        } else {
          filterData.remove('userId');
          setState(() {
            choosePerson.clear();
          });
        }
        setState(() {
          scopeSelectIndex = index;
        });
        break;
      case 1:
        if (data['title'] != '全部时间') {
          DateRange dateRange = ConvertDate.convertDateTextToRealValue(data['title']);
          filterData['startTime'] = dateRange.startTime;
          filterData['endTime'] = dateRange.endTime;
        } else {
          filterData.remove('startTime');
          filterData.remove('endTime');
        }
        setState(() {
          dateSelectIndex = index;
        });
        break;
      case 2:
        if (data['value'] != '') {
          filterData['finishStatus'] = data['value'];
        } else {
          filterData.remove('finishStatus');
        }
        setState(() {
          statusSelectIndex = index;
        });
        break;
      case 3:
        if (data['value'] != '') {
          filterData['orderBy'] = data['value'];
        } else {
          filterData.remove('orderBy');
        }
        setState(() {
          orderTypeSelectIndex = index;
        });
        break;
    }
    onRefresh();
  }
}
