import 'package:amos_flutter_utils/amos_flutter_utils.dart';
import 'package:amos_iot_login_tpl/amos_iot_login_tpl.dart';
import 'package:flutter/material.dart';
import 'package:jcs_airport/consts/Logger.dart';
import 'package:webview_flutter/webview_flutter.dart';
import 'package:amos_iot_login_tpl/const/global_config.dart';
import 'package:jcs_airport/consts/url_const.dart';

///@Description     救援预案
///@author          helinlin
///@create          2021-12-10 10:55
class PlanWebView extends StatefulWidget {
  final String sequenceNbr;

  const PlanWebView({Key key, this.sequenceNbr}) : super(key: key);

  @override
  _PlanWebViewState createState() => _PlanWebViewState();
}

class _PlanWebViewState extends State<PlanWebView> {
  WebViewController webViewController;
  String _h5Url;
  String token;

  @override
  void initState() {
    super.initState();
    getUrl();
  }

  Future<void> getUrl() async {
    //获取token
    SPTools _sp = await SPTools.instance;
    token = _sp.getString(GlobalConst.token);
    //获取文档地址
    _h5Url = await APIUrlManager.getH5Url();
    Uri uri = Uri.parse(_h5Url ?? URLConst.MAP_H5_URL);
    String address = uri.scheme + '://' + uri.host + ':' + uri.port.toString();
    setState(() {
      _h5Url = address + URLConst.PLAN_H5_URL + '?fileid=' + widget.sequenceNbr + '&token=' + token;
      Logger.info(_h5Url);
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text('救援预案'),
      ),
      body: _h5Url != null
          ? WebView(
              initialUrl: _h5Url,
              javascriptMode: JavascriptMode.unrestricted,
              onWebViewCreated: (WebViewController controller) {
                webViewController = controller;
              },
            )
          : Container(),
    );
  }
}
