import 'package:flutter/material.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:jcs_airport/services/api.dart';

/// 修改车辆状态
class CarStatusSelect extends StatefulWidget {
  const CarStatusSelect(
      {Key key,
      this.selectKey,
      this.onChanged,
      this.bindingCarId,
      this.alertCallId,
      this.carStatus,
      this.ok})
      : super(key: key);
  final void Function(String selectKey) onChanged;
  final String bindingCarId;
  final String alertCallId;
  final String selectKey;
  final List<Map<String, String>> carStatus;
  final Function ok;

  @override
  _CarStatusSelectState createState() => _CarStatusSelectState();
}

class _CarStatusSelectState extends State<CarStatusSelect> {
  String selectKey;

  @override
  void initState() {
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Center(
      child: Container(
        height: 400.0,
        child: Column(
          children: [
            TagSelectPanel(
                crossAxisCount: 3,
                datas: widget.carStatus ?? [],
                selectKey: widget.selectKey ?? '',
                onChanged: (key) {
                  setState(() {
                    selectKey = key ?? '';
                  });
                }),
            Row(mainAxisAlignment: MainAxisAlignment.spaceBetween, children: [
              ExpandedButton(
                height: 48.0,
                child: const Text('取消'),
                onPressed: (){
                  Navigator.of(context).pop();
                },
              ),
              ExpandedButton(
                height: 48.0,
                color: const Color(0xff345fa6),
                child: const Text(
                  '确定',
                  style: TextStyle(color: Colors.white),
                ),
                onPressed: () {
                  setCarStatus();
                  widget.ok();
                  Navigator.of(context).pop();
                },
              ),
            ])
          ],
        ),
      ),
    );
  }

  ///车辆状态选择后回调
  void setCarStatus() {
    API.setCurrentCarOrTaskState(widget.bindingCarId, widget.alertCallId, selectKey, '1').then((value) {});
  }
}

///车辆状态选择弹出框
void openSourceTypeDialog(BuildContext context, {Function onChanged, String selectKey}) {
  showDialog(
    context: context,
    barrierDismissible: false,
    builder: (BuildContext context) {
      return StatefulBuilder(builder: (BuildContext context, StateSetter ss) {
        return Dialog(
          insetPadding: const EdgeInsets.symmetric(horizontal: 6.0),
          child: CarStatusSelect(
            onChanged: onChanged,
            selectKey: selectKey,
          ),
        );
      });
    },
  );
}
