import 'package:flutter/material.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';

const List<Map<String, String>> _resourceMaps = [
  {'key': 'linkageForce', 'label': '联动力量'},
  {'key': 'rescueTeam', 'label': '救援队伍'},
  {'key': 'miniFireStation', 'label': '微型消防站'},
  {'key': 'SY500', 'label': '500m水源'},
  {'key': 'SY1000', 'label': '1000m水源'},
  {'key': 'professionalTeam', 'label': '志愿救援'},
  {'key': 'defendTarget', 'label': '重点单位'},
  {'key': 'video', 'label': '视频'},
];

/// 选择资源类型
class SelectResourceType extends StatelessWidget {
  const SelectResourceType({Key key, this.selectKeys, this.onChanged})
      : super(key: key);

  final List<String> selectKeys;
  final void Function(List<String> selectKeys) onChanged;

  @override
  Widget build(BuildContext context) {
    return Container(
        child: MultiTagSelectPanel(
            crossAxisCount: 3,
            datas: _resourceMaps,
            selectKeys: selectKeys,
            onChanged: onChanged));
  }
}

/// 选择资源类型, 包含 底部按钮
class SelectResourceTypePanel extends StatelessWidget {
  const SelectResourceTypePanel(
      {Key key, this.selectKeys, this.onChanged, this.reset, this.ok})
      : super(key: key);

  final List<String> selectKeys;
  final void Function(List<String> selectKeys) onChanged;
  final Function reset;
  final Function ok;

  @override
  Widget build(BuildContext context) {
    return Container(
        height: 256.0,
        child: Column(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              MultiTagSelectPanel(
                  crossAxisCount: 3,
                  datas: _resourceMaps,
                  selectKeys: selectKeys,
                  onChanged: onChanged),
              Row(mainAxisAlignment: MainAxisAlignment.spaceBetween, children: [
                ExpandedButton(
                  height: 48.0,
                  child: const Text('重置'),
                  onPressed: reset,
                ),
                ExpandedButton(
                  height: 48.0,
                  color: const Color(0xff345fa6),
                  child: const Text(
                    '确定',
                    style: TextStyle(color: Colors.white),
                  ),
                  onPressed: () {
                    Navigator.of(context).pop();
                    ok();
                  },
                ),
              ])
            ]));
  }
}

void openSourceTypeDialog(BuildContext context,
    {Function reset,
    Function ok,
    Function onChanged,
    List<String> selectKeys}) {
  showDialog(
    context: context,
    /// 只有点击按钮才能关闭
    barrierDismissible: false,
    builder: (BuildContext context) {
      return StatefulBuilder(builder: (BuildContext context, StateSetter ss) {
        return Dialog(
          // insetPadding: EdgeInsets.zero,
          insetPadding: const EdgeInsets.symmetric(horizontal: 6.0),
          child: SelectResourceTypePanel(
            onChanged: onChanged,
            selectKeys: selectKeys,
            reset: () {
              reset(() {
                ss(() {});
              });
            },
            ok: ok,
          ),
        );
      });
    },
  );
}
