import 'dart:convert';

/// 警情详情
class AlarmDisaster {
  String sequenceNbr;
  String alertStage;
  String callTime;
  String alertType;
  String alarmTypeCode;
  String unitInvolved;
  int trappedNum;
  int casualtiesNum;
  String address;
  String rescueGrid;
  String longitude;
  String latitude;
  String distance;
  String responseLevelCode;
  Map<String, dynamic> strengthCount;
  Map<String, dynamic> alarmDetails;
  List rescueObject;

  AlarmDisaster(
      {this.sequenceNbr,
      this.alertStage,
      this.callTime,
      this.alertType,
      this.alarmTypeCode,
      this.unitInvolved,
      this.trappedNum,
      this.casualtiesNum,
      this.address,
      this.rescueGrid,
      this.longitude,
      this.latitude,
      this.responseLevelCode,});

  AlarmDisaster.fromJson(Map<String, dynamic> json) {
    sequenceNbr = json['sequenceNbr'];
    alertStage = json['alertStage'];
    callTime = json['callTime'];
    alertType = json['alertType'];
    alarmTypeCode = json['alarmTypeCode'];
    unitInvolved = json['unitInvolved'];
    trappedNum = json['trappedNum'];
    casualtiesNum = json['casualtiesNum'];
    address = json['address'];
    rescueGrid = json['rescueGrid'];
    longitude = json['longitude'];
    latitude = json['latitude'];
    responseLevelCode = json['responseLevelCode'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['sequenceNbr'] = sequenceNbr;
    data['alertStage'] = alertStage;
    data['callTime'] = callTime;
    data['alertType'] = alertType;
    data['alarmTypeCode'] = alarmTypeCode;
    data['unitInvolved'] = unitInvolved;
    data['trappedNum'] = trappedNum;
    data['casualtiesNum'] = casualtiesNum;
    data['address'] = address;
    data['rescueGrid'] = rescueGrid;
    data['longitude'] = longitude;
    data['latitude'] = latitude;
    data['responseLevelCode'] = responseLevelCode;
    return data;
  }
}

/// 经纬度实体对象
class LngLat {
  LngLat(this.lng, this.lat);

  /// 经度
  double lng;

  /// 纬度
  double lat;

  LngLat.fromJson(Map<String, double> json) {
    lng = json['lng'];
    lat = json['lat'];
  }

  LngLat.fromJsonStr(String jsonStr) {
    Map<String, double> map = jsonDecode(jsonStr);
    lng = map['lng'];
    lat = map['lat'];
  }

  static LngLat fromMap(Map<String, double> map) {
    LngLat jsonModel = LngLat(map['lng'], map['lat']);
    return jsonModel;
  }

  /// 将 LngLat 转化为 js 识别的数据
  static String toJsJson(LngLat ll) {
    return jsonEncode(ll);
  }

  Map toJson() {
    Map map = <String, double>{};
    map['lng'] = lng;
    map['lat'] = lat;
    return map;
  }

  @override
  String toString() {
    return 'LngLat: {lng: $lng, lat: $lat}';
  }
}
