import 'package:flutter/material.dart';
import 'package:amos_iot_ui/charts/annular_chart.dart';
import 'package:jcs_airport/services/api.dart';

/// 力量调度统计
class Statistics extends StatefulWidget {
  final String alarmId;
  final String type;
  Statistics(this.alarmId, this.type);

  @override
  _StatisticsState createState() => _StatisticsState();
}

class _StatisticsState extends State<Statistics> {
  List<Map<String, Object>> _dataCount = [];

  int allCount = 0;
  int arrived = 0;
  int underway = 0;

  @override
  void initState() {
    super.initState();
    loadData();
  }

  @override
  Widget build(BuildContext context) {
    return Expanded(
        child: Container(
            decoration: const BoxDecoration(color: Colors.white),
            child: Column(children: [
              Expanded(
                  flex: 2,
                  child: Align(
                      alignment: FractionalOffset.center,
                      child: Stack(children: [
                        AnnularChart(_dataCount
                            .map((element) => SeriesData(element['count'],
                                element['title'], element['color']))
                            .toList())
                      ]))),
              Expanded(child: Row(children: getBottonWidget()))
            ])));
  }

  List<Widget> getBottonWidget() {
    List<Widget> list = List();
    list.add(Expanded(
        child: Row(mainAxisAlignment: MainAxisAlignment.center, children: [
      Column(children: [
        Text(allCount.toString(), style: const TextStyle(fontSize: 30)),
        const Text('全部', style: TextStyle(color: Color(0xffafafaf)))
      ])
    ])));
    _dataCount.forEach((element) {
      list.add(Expanded(
          child: Row(mainAxisAlignment: MainAxisAlignment.center, children: [
        Column(children: [
          Text(element['count'].toString(),
              style: TextStyle(color: element['color'], fontSize: 30)),
          Text(element['title'],
              style: const TextStyle(color: Color(0xffafafaf)))
        ])
      ])));
    });
    return list;
  }

  Future<void> loadData() async {
    Map<String, dynamic> query = {};
    query['type'] = widget.type;
    query['alertId'] = widget.alarmId;
    // Map<String, dynamic> result =
    //     (await API.getTransferstatistics(query)).cast<String, dynamic>();
    API.getTransferstatistics(query).then((data) {
      // List data = result['records'];
      data.forEach((element) {
        if (element['type'] == widget.type) {
          setState(() {
            allCount = element['allCount'];
            arrived = element['arrived'];
            underway = element['underway'];
            dynamic arruveddata = {
              'count': arrived,
              'title': '到达',
              'color': Colors.yellow
            };
            dynamic underwaydata = {
              'count': 0,
              'title': '未达',
              'color': Colors.orange
            };
            List<Map<String, Object>> countList = [];
            countList.add(arruveddata);
            countList.add(underwaydata);
            _dataCount = countList;
          });
        }
      });
    });
  }
}
