import 'package:flutter/material.dart';

/// 主页面
class Index extends StatefulWidget {
  const Index(this.barItems, this.navPages);

  final List barItems;
  final List<Widget> navPages;

  @override
  _IndexState createState() => _IndexState();
}

class _IndexState extends State<Index> {
  int _currentIndex = 0;

  @override
  void initState() {
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: IndexedStack(
        index: _currentIndex,
        children: widget.navPages,
      ),
      bottomNavigationBar: BottomNavigationBar(
        unselectedFontSize: Theme.of(context).tabBarTheme.labelStyle.fontSize,
        selectedFontSize: Theme.of(context).tabBarTheme.labelStyle.fontSize,
        items: widget.barItems,
        currentIndex: _currentIndex,
        onTap: (index) {
          setState(() {
            _currentIndex = index;
          });
        },
      ),
    );
  }
}
