import 'package:flutter/material.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import './MeasurementScanCode.dart';
class InspectionPage extends StatefulWidget {
  final String bizType;

  InspectionPage({Key key, @required this.bizType}) : super(key: key);

  @override
  _InspectionPageState createState() => _InspectionPageState();
}

class _InspectionPageState extends State<InspectionPage> {
  // 模拟已扫设备数据
  List<Map<String, String>> deviceList = [

  ];
  // 跳转到第二个页面，并接收返回值
  void _navigateToSecondPage() async {
    // 使用 await 等待第二个页面返回的参数
    final result = await Navigator.push(
      context,
      MaterialPageRoute(
        builder: (context) => MeasurementScanCode(bizType: widget.bizType),
      ),
    );

    // 判断返回值不为空时更新UI
    if (result != null) {

      deviceList.insert(0, {
        'name': result['equipmentCode'] ?? '',
        'code': result['equipmentName'] ?? '',
        'plan': '自检计划20251002'
      });
      setState(() {
        deviceList = deviceList;
      });
    }
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text("送检"),
        // 低版本AppBar返回按钮适配
        leading: IconButton(
          icon: Icon(Icons.arrow_back),
          onPressed: () => Navigator.pop(context),
        ),
      ),
      body: Column(
        crossAxisAlignment: CrossAxisAlignment.stretch,
        children: [
          // 已扫设备列表区域
          Expanded(
            child: Card(
              elevation: 0,
              // width: double.infinity,
              margin: EdgeInsets.fromLTRB(12,12,12,12),
              shape: RoundedRectangleBorder(
                borderRadius: BorderRadius.circular(8), // 圆角卡片
              ),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Container(
                    padding:  EdgeInsets.fromLTRB(12,12,0,6),
                    child:  Text(
                      "已送检设备列表",
                      style: TextStyle(
                        fontSize: 18,
                        fontWeight: FontWeight.bold,
                        color: Colors.black87,
                      ),
                    ),
                  ),

                  SizedBox(height: 12),
                  // 设备列表
                  Expanded(
                    child: ListView.builder(
                      itemCount: deviceList.length,
                      padding: EdgeInsets.fromLTRB(12,0,12,12),
                      itemBuilder: (context, index) {
                        final device = deviceList[index];
                        return Container(
                          padding: EdgeInsets.symmetric(vertical: 12),
                          decoration: BoxDecoration(
                            border: Border(
                              bottom: BorderSide(color: Colors.grey[200], width: 1),
                            ),
                          ),
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Text(
                                device["name"],
                                style: TextStyle(
                                  fontSize: 16,
                                  fontWeight: FontWeight.w500,
                                ),
                              ),
                              SizedBox(height: 4),
                              Text("编号：${device["code"]}", style: TextStyle(fontSize: 14, color: Colors.grey[600])),
                              Text("${device["plan"]}", style: TextStyle(fontSize: 14, color: Colors.grey[600])),
                            ],
                          ),
                        );
                      },
                    ),
                  ),
                ],
              ),
            ),
          ),
          // 扫码核验区域

          Card(
            elevation: 0,
            // width: double.infinity,
            margin: EdgeInsets.fromLTRB(12 ,0,12,12),
            shape: RoundedRectangleBorder(
              borderRadius: BorderRadius.circular(8), // 圆角卡片
            ),
            child:Padding(
              padding: EdgeInsets.all(16),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.stretch,
                children: [
                  Text(
                    "设备扫码送检",
                    style: TextStyle(
                      fontSize: 18,
                      fontWeight: FontWeight.bold,
                      color: Colors.black87,
                    ),
                  ),
                  SizedBox(height: 16),
                  Column(
                    children: [
                      Text(
                        "将设备二维码对准扫描框进行识别",
                        style: TextStyle(fontSize: 14, color: Colors.grey[600]),
                      ),
                      SizedBox(height: 8),
                      Container(
                        width: double.infinity,
                       padding: EdgeInsets.symmetric(horizontal: 20, vertical: 0),
                       child: ElevatedButton(
                        onPressed: _navigateToSecondPage,

                        style: ElevatedButton.styleFrom(

                          primary: Color.fromRGBO(0, 153, 255, 1.0),
                          padding: EdgeInsets.symmetric(horizontal: 40, vertical: 12),
                          shape: RoundedRectangleBorder(
                            borderRadius: BorderRadius.circular(4),
                          ),
                        ),
                        child: Text(
                          "启动扫一扫",
                          style: TextStyle(fontSize: 16, color: Colors.white),
                        ),
                      ),
                      )
                    ],
                  )


                ],
              ),
            )
          ),
        ],
      ),
    );
  }
}