import 'package:flutter/material.dart';
import 'package:flutter/rendering.dart';
import 'theme_base.dart';

import 'common.dart';

class TimerWidget extends StatefulWidget {

  String name;
  String title;

  TimerWidget({this.title}) ;

  @override
  State<StatefulWidget> createState() {
    var state = new _TimerWidgetState(this.title);
    state.startClock();
    return state;
  }
}

class _TimerWidgetState extends ClockBaseState<TimerWidget> {
  String title;
  _TimerWidgetState(this.title);


  @override
  Widget build(BuildContext context) {
    return Column(
        mainAxisAlignment: MainAxisAlignment.center,
        children: [
          Text(
            title,
            textAlign: TextAlign.start,
            style: TextStyle(color: Colors.white, fontSize: 24.0,),
          ),
          Text.rich(
          TextSpan(
          children: [
              TextSpan(
              text:
              " ${pad0(now.hour)}:${pad0(now.minute)}:${pad0(now.second)}",
          style: TextStyle(
          fontSize: 18.0,
          color: Colors.white,
          height: 1.5,
          ))
          ])
          )
        ]
    );
  }
}

