import 'package:flutter/material.dart';

import './widget/dynamic_datetime.dart';
import './widget/dynamic_input.dart';
import './widget/dynamic_radio.dart';
import './widget/dynamic_select.dart';
import './widget/dynamic_textarea.dart';
import './widget/dynamic_upload.dart';
import './widget/dynamic_select_tree.dart';

/// 解析表单
/// @param context 上下文
/// @param formData 表单数据
/// @param formStructure 表单结构
/// @param formValidator 表单验证
/// @param processInstancePayload 流程实例参数
/// @param editable 是否可编辑
List<Widget> parseForm(
    BuildContext context,
    Map<String, dynamic> formData,
    List<dynamic> formStructure,
    Map<String, dynamic> formValidator,
    Map<String, dynamic> processInstancePayload,
    bool editable) {
  List<Widget> widgets = [];
  for (final Map<String, dynamic> formItem in formStructure) {
    String componentKey = formItem['componentKey'];
    Map<String, dynamic> visualParams = formItem['visualParams'];

    Widget widget;
    switch (componentKey) {
      case 'columnsLayout':
        (formItem['children'] ?? []).forEach((element) {
          widgets.addAll(parseForm(context, formData, element['children'],
              formValidator, processInstancePayload, editable));
        });
        break;
      case 'input':
        widget = DynamicInput(
            formData: formData,
            visualParams: visualParams,
            formValidator: formValidator,
            processInstancePayload: processInstancePayload,
            editable: editable);
        break;
      case 'textArea':
        widget = DynamicTextArea(
            formData: formData,
            visualParams: visualParams,
            formValidator: formValidator,
            processInstancePayload: processInstancePayload,
            editable: editable);
        break;
      case 'radio':
        widget = DynamicRadio(
            formData: formData,
            visualParams: visualParams,
            formValidator: formValidator,
            editable: editable);
        break;
      case 'select':
        widget = buildDynamicSelect(
            context, formData, visualParams, formValidator, editable);
        break;
      case 'dateTime':
        widget = DynamicDataTime(
            formData: formData,
            visualParams: visualParams,
            formValidator: formValidator,
            processInstancePayload: processInstancePayload,
            editable: editable);
        break;
      case 'upload':
        widget = DynamicUpload(
            formData: formData,
            visualParams: visualParams,
            formValidator: formValidator,
            editable: editable);
        break;
      case 'selectTree':
        //临时只有回显
        widget = buildDynamicSelectTree(
            context, formData, visualParams, formValidator, false);
        break;
      default:
        break;
    }
    _createValidator(formValidator, visualParams);
    if (widget != null) {
      widgets.add(widget);
    }
  }

  return widgets;
}

void _createValidator(
    Map<String, dynamic> formValidator, Map<String, dynamic> visualParams) {
  String label = visualParams['label'];
  String fieldName = visualParams['fieldKey'];


  List<dynamic> rules = visualParams['rules'];

  if (rules == null) {
    return;
  }
  rules = rules.where((element) {
    // 如果是字符串，则过滤掉空字符串
    if (element is String) {
      return element.isNotEmpty;
    }
    // 如果是其他类型，则过滤掉null
    return element != null;
  }).toList();
  bool required =
      rules.any((rule) => rule['name'] == 'required' && rule['enable']);
  formValidator[fieldName] = {'required': required, 'message': '请输入$label'};
}
