import 'package:flutter/material.dart';
import 'dart:convert';
import 'package:jcs_airport/consts/styles.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:jcs_airport/view/task/utils/widget_behavior.dart';
import 'package:shared_preferences/shared_preferences.dart';

/// 文本输入框
class DynamicInput extends StatefulWidget {
  final Map<String, dynamic> formData;
  final Map<String, dynamic> visualParams;
  final Map<String, dynamic> formValidator;
  final Map<String, dynamic> processInstancePayload;
  final bool editable;

  const DynamicInput(
      {Key key,
      this.formData,
      this.visualParams,
      this.formValidator,
      this.processInstancePayload,
      this.editable})
      : super(key: key);

  @override
  _DynamicInputState createState() => _DynamicInputState();
}




class _DynamicInputState extends State<DynamicInput> {
  @override
  Widget build(BuildContext context) {


    if (isHidden(widget.visualParams)) {
      String value = widget.visualParams['defaultValue'] ?? '';
      String defaultValueType = widget.visualParams['defaultValueType'];
      if (defaultValueType == 'dataLink') {
        Map<String, dynamic> defaultValueDataLink = widget.visualParams['defaultValueDataLink'];
        if (defaultValueDataLink != null && defaultValueDataLink['source'] == 'urlParams') {
          value = widget.processInstancePayload[defaultValueDataLink['value']['prop']] ?? widget.processInstancePayload[defaultValueDataLink['value']['defaultValue']];
          setState(() {
            widget.formData[widget.visualParams['fieldKey']] = value;
          });
        }
      }

      return Container();
    }
    return Row(
      children: <Widget>[
        Container(
          height: 95,
          padding: EdgeInsets.only(top: 15.0),
          child: Text(
            widget.visualParams!=null &&   widget.formValidator!=null? (widget.formValidator[widget.visualParams['fieldKey']]!=null ? widget.formValidator[widget.visualParams['fieldKey']]['required'] : false ) ?  '*':'':'',
            textAlign: TextAlign.left,
            //文字放大倍数
            textScaleFactor: 1.0,
            //文本最多显示几行
            maxLines: 1,
            style: TextStyle(color: Colors.red),
          ),
        ),

        Expanded(
          child:  FormItem(
              layout: FormLayout.vertical,
              label:  widget.visualParams['label'],
              formfield: !widget.editable || isReadonly(widget.visualParams)
                  ? buildReadonlyWidget()
                  : ITextFormField(
                  value: widget.formData[widget.visualParams['fieldKey']] ?? widget.visualParams['defaultValue'] ?? '',
                  textStyle: CoreStyles.smallText,
                  hintText: widget.visualParams['placeholder'],
                  onChanged: (val) {
                    widget.formData[widget.visualParams['fieldKey']] = val;
                  })
          ),
        ),
      ],
    );








  }

  Widget buildReadonlyWidget() {
    String value = '';
    if (!widget.editable) {
      value = widget.formData[widget.visualParams['fieldKey']] ?? widget.visualParams['defaultValue'] ?? '';
      setState(() {
        widget.formData[widget.visualParams['fieldKey']] = value;
      });
    } else {
      String defaultValue = widget.visualParams['defaultValue'];
      String defaultValueType = widget.visualParams['defaultValueType'];
      switch (defaultValueType) {
        case 'custom':
            value = defaultValue ?? '';
          break;
        case 'dataLink':
          Map<String, dynamic> defaultValueDataLink = widget.visualParams['defaultValueDataLink'];
          if (defaultValueDataLink!=null && defaultValueDataLink['source'] == 'urlParams') {
            value = widget.processInstancePayload[defaultValueDataLink['value']['prop']] ?? widget.processInstancePayload[defaultValueDataLink['value']['defaultValue']];
            setState(() {
              widget.formData[widget.visualParams['fieldKey']] = value;
            });
          }else if(defaultValueDataLink != null && defaultValueDataLink['source'] == 'currentAuthParam'){
            getUserName(widget.visualParams['fieldKey']);
          }
          break;
        default:
          break;
        }
    }


    return TextField(
      style: const TextStyle(fontSize: 14),
      readOnly: true,
      controller: TextEditingController(
          text: widget.formData[widget.visualParams['fieldKey']]),
      autofocus: false,
      maxLines: 1,
      decoration: const InputDecoration(
        contentPadding:
        EdgeInsets.symmetric(vertical: 10.0, horizontal: 10),
        border: InputBorder.none,
        filled: true,
        fillColor: Color.fromRGBO(244, 244, 244, 1),
      ),
    );
  }


   Future<String> getUserName(String a) async {
    var _userName='';
      SharedPreferences prefers = await SharedPreferences.getInstance();
    if (prefers.containsKey('myInfo')) {
      _userName = json.decode( prefers.getString("myInfo"))["realName"];
      setState(() {
        widget.formData[a] = _userName;
      });
      }
    return _userName;
  }
}
