import 'package:flutter/material.dart';
import 'package:jcs_airport/view/task/utils/widget_behavior.dart';

class DynamicRadio extends StatefulWidget {
  final Map<String, dynamic> formData;
  final Map<String, dynamic> visualParams;
  final Map<String, dynamic> formValidator;
  final bool editable;

  const DynamicRadio({
    Key key,
    this.formData,
    this.visualParams,
    this.formValidator,
    this.editable,
  }) : super(key: key);

  @override
  State<StatefulWidget> createState() => _DynamicRadioState();
}

class _DynamicRadioState extends State<DynamicRadio> {
  @override
  void initState() {
    super.initState();
    widget.formData[widget.visualParams['fieldKey']] =
    widget.visualParams['defaultValue'];
  }

  @override
  Widget build(BuildContext context) {
    if (isHidden(widget.visualParams)) {
      return Container();
    }
    return Container(
      padding: const EdgeInsets.only(top: 10, bottom: 5),
      child: Column(
        children: <Widget>[
          Row(
            children: <Widget>[
              Container(
                child: Text(
                  widget.visualParams!=null &&   widget.formValidator!=null? (widget.formValidator[widget.visualParams['fieldKey']]!=null ? widget.formValidator[widget.visualParams['fieldKey']]['required'] : false ) ?  '*':'':'',
                  textAlign: TextAlign.left,
                  //文字放大倍数
                  textScaleFactor: 1.0,
                  //文本最多显示几行
                  maxLines: 1,
                  style: TextStyle(color: Colors.red),
                ),
              ),
              Container(
                padding: const EdgeInsets.only(
                  left: 20,
                ),
                child: Text(
                  widget.visualParams['label'],
                  style: const TextStyle(
                    color: Colors.black,
                    fontSize: 14,
                  ),
                ),
              ),
            ],
          ),
          Container(
            // width: MediaQuery.of(context).size.width - 20,
            padding: const EdgeInsets.only(
              left: 20,
              top: 5,
              bottom: 5,
            ),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.start,
              children:
              List.generate(widget.visualParams['data'].length, (index) {
                return Expanded(
                  flex: 1,
                  child: Row(
                    children: <Widget>[
                      Radio(
                        activeColor: Theme.of(context).primaryColor,
                        value: widget.visualParams['data'][index]['value'],
                        groupValue:
                        widget.formData[widget.visualParams['fieldKey']] ??
                            widget.visualParams['defaultValue'],
                        onChanged: (val) {
                          if (widget.editable && !isReadonly(widget.visualParams)) {
                            setState(() {
                              widget.formData[widget.visualParams['fieldKey']] =
                                  val;
                            });
                          }
                        },
                      ),
                      GestureDetector(
                        child: Text(widget.visualParams['data'][index]['name']),
                        onTap: () {
                          if (widget.editable && !isReadonly(widget.visualParams)) {
                            setState(() {
                              widget.formData[widget.visualParams['fieldKey']] =
                              widget.visualParams['data'][index]['value'];
                            });
                          }
                        },
                      )
                    ],
                  ),
                );
              }),
            ),
          ),
        ],
      ),
    );
  }
}
