import 'package:flutter/material.dart';
import 'package:jcs_airport/consts/styles.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:jcs_airport/view/task/utils/widget_behavior.dart';

/// 富文本输入框
class DynamicTextArea extends StatefulWidget {
  final Map<String, dynamic> formData;
  final Map<String, dynamic> visualParams;
  final Map<String, dynamic> formValidator;
  final Map<String, dynamic> processInstancePayload;
  final bool editable;

  const DynamicTextArea(
      {Key key,
      this.formData,
      this.visualParams,
      this.formValidator,
      this.processInstancePayload,
      this.editable})
      : super(key: key);

  @override
  _DynamicTextAreaState createState() => _DynamicTextAreaState();
}

class _DynamicTextAreaState extends State<DynamicTextArea> {
  @override
  Widget build(BuildContext context) {
    if (isHidden(widget.visualParams)) {
      String value = widget.visualParams['defaultValue'] ?? '';
      String defaultValueType = widget.visualParams['defaultValueType'];
      if (defaultValueType == 'dataLink') {
        Map<String, dynamic> defaultValueDataLink = widget.visualParams['defaultValueDataLink'];
        if (defaultValueDataLink != null && defaultValueDataLink['source'] == 'urlParams') {
          value = widget.processInstancePayload[defaultValueDataLink['value']['prop']] ?? widget.processInstancePayload[defaultValueDataLink['value']['defaultValue']];
        }
      }
      setState(() {
        widget.formData[widget.visualParams['fieldKey']] = value;
      });
      return Container();
    }
    return Row(
      children: <Widget>[
        Container(
          height: 100,
          padding: EdgeInsets.only(top: 0.0),
          child: Text(
            widget.visualParams!=null &&   widget.formValidator!=null? (widget.formValidator[widget.visualParams['fieldKey']]!=null ? widget.formValidator[widget.visualParams['fieldKey']]['required'] : false ) ?  '*':'':'',
            textAlign: TextAlign.left,
            //文字放大倍数
            textScaleFactor: 1.0,
            //文本最多显示几行
            maxLines: 1,
            style: TextStyle(color: Colors.red),
          ),
        ),

        Expanded(
          child:        FormItem(
              layout: FormLayout.vertical,
              label: widget.visualParams['label'],
              formfield: !widget.editable || isReadonly(widget.visualParams)
                  ? buildReadonlyWidget()
                  : ITextFormField(
                  value: widget.formData[widget.visualParams['fieldKey']] ??
                      widget.visualParams['defaultValue'] ??
                      '',
                  maxLines: 4,
                  textStyle: CoreStyles.smallText,
                  hintText: widget.visualParams['placeholder'],
                  onChanged: (val) {
                    widget.formData[widget.visualParams['fieldKey']] = val;
                  })),
        ),
      ],
    );

  }

  Widget buildReadonlyWidget() {
    String value = '';
    if (!widget.editable) {
      value = widget.formData[widget.visualParams['fieldKey']] ??
          widget.visualParams['defaultValue'] ??
          '';
    } else {
      String defaultValue = widget.visualParams['defaultValue'];
      if (defaultValue != null) {
        value = defaultValue;
      }
    }

    setState(() {
      widget.formData[widget.visualParams['fieldKey']] = value;
    });

    return TextField(
      style: const TextStyle(fontSize: 14),
      readOnly: true,
      controller: TextEditingController(text: value),
      autofocus: false,
      maxLines: 4,
      decoration: const InputDecoration(
        contentPadding: EdgeInsets.symmetric(vertical: 10.0, horizontal: 10),
        border: InputBorder.none,
        filled: true,
        fillColor: Color.fromRGBO(244, 244, 244, 1),
      ),
    );
  }
}
