import 'package:flutter/material.dart';
import './timeline_entity.dart';
import './timeline_item.dart';

final Map<String, Color> defaultStatusColors = {
  'success': Colors.green,
  'processing': Color(0xff345fa6),
  'default': Colors.grey,
  'error': Colors.red,
  'warning': Colors.orange
};

class TimelineNew extends StatefulWidget {
  final List<TimelineEntity> timelineList;

  final Color lineColor;
  final Color dotColor;
  final Color backgroundColor;
  /// 状态颜色枚举
  final Map<String, Color> statusColors;

  final Color textColor;

  const TimelineNew(
      {Key key,
        this.timelineList,
        this.lineColor,
        this.dotColor,
        this.backgroundColor,
        this.statusColors,
        this.textColor})
      : super(key: key);

  @override
  TimelineNewState createState() {
    return new TimelineNewState();
  }
}

class TimelineNewState extends State<TimelineNew>
    with SingleTickerProviderStateMixin {

  Color getStatusColor(TimelineEntity item){
    final dc = widget.dotColor == null ? Colors.blue : widget.dotColor;
    final mapper = widget.statusColors ?? defaultStatusColors;
    return mapper[item.status] ?? dc;
  }

  @override
  Widget build(BuildContext context) {
    return new Container(
      padding: EdgeInsets.symmetric(vertical: 6.0),
      child: new ListView.builder(
        itemCount: widget.timelineList.length,
        shrinkWrap: true,
        itemBuilder: (BuildContext bc, int index) {
          final TimelineEntity model = widget.timelineList[index];
          return TimelineItem(
              lineColor: widget.lineColor == null
                  ? Theme.of(context).accentColor
                  : widget.lineColor,
              dotColor: getStatusColor(model),
              backgroundColor: widget.backgroundColor == null ? Colors.white : widget.backgroundColor,
              model: model,
              firstElement: index == 0,
              lastElement: widget.timelineList.length == index + 1,
              textColor: widget.textColor
          );
        },
      ),
    );
  }
}
