import 'package:flutter/material.dart';

/// 时间轴拖尾
class TimelineTail extends StatelessWidget {
  final Color lineColor;
  final Color dotColor;
  final Color backgroundColor;
  const TimelineTail({
    Key key,
    @required this.lineColor,
    @required this.dotColor,
    @required this.backgroundColor,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return LayoutBuilder(builder: (BuildContext context, BoxConstraints constraints){
      final height = constraints.constrainHeight();
      return Container(
          color: backgroundColor,
          child: Column(
            mainAxisAlignment: MainAxisAlignment.center,
            children: [
              Container(
                  width: 10,
                  height: 10,
                  decoration: BoxDecoration(
                      color: dotColor,
                      borderRadius: BorderRadius.circular(10)
                  )
              ),
              Container(
                width: 1,
                height: height - 13,
                color: lineColor,
                margin: EdgeInsets.only(top: 3),
              )
            ],
          )
      );
    });
  }
}