import 'package:get/get.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:jcs_airport/services/api.dart';
import 'package:jcs_airport/view/common/base_choose_person.dart';

///@Description     检查人员
///@author          helinlin
///@create          2021-09-03 15:32
class ChooseFireproofSupervisionPerson extends BaseChoose {

  @override
  BaseChooseState getBaseChoosePersonState() => ChooseFireproofSupervisionPersonState();

  ChooseFireproofSupervisionPerson( {Map person, bool multi, List<Map> persons})
      : super(person: person, multi: multi, persons: persons);
}

class ChooseFireproofSupervisionPersonState extends BaseChooseState {
  @override
  Future<void> getData() async {
    Future.delayed(Duration.zero, () async {
      MsgBox.showProgressDialog(context, content: '加载中，请稍后...');
      var data = await API.jcsOrgUsrListPerson();
      Get.back();
      setState(() {
        if (data != null) {
          persons.addAll(data['records']);
        }
      });
    });
  }

  @override
  String getIdKey() => 'sequenceNbr';

  @override
  String getNameKey() => 'bizOrgName';
}
