import 'package:amos_flutter_ui/message/message_box.dart';
import 'package:get/get.dart';
import 'package:jcs_airport/services/api.dart';
import 'package:jcs_airport/view/common/base_choose_person.dart';

///@Description     选择计划
///@author          helinlin
///@create          2021-10-08 15:12
class CheckPlan extends BaseChoose {
  CheckPlan({Map plan, bool multi, List<Map> plans}) : super(person: plan, multi: multi, persons: plans);

  @override
  BaseChooseState getBaseChoosePersonState() => _CheckPlanState();
}

class _CheckPlanState extends BaseChooseState {
  @override
  Future<void> getData() async {
    Future.delayed(Duration.zero, () async {
      MsgBox.showProgressDialog(context, content: '加载中，请稍后...');
      var data = await API.queryPlanList();
      Get.back();
      setState(() {
        if (data != null) {
          persons.addAll(data);
        }
      });
    });
  }

  @override
  String getIdKey() => 'id';

  @override
  String getNameKey() => 'name';
}
