import 'package:flutter/material.dart';
import 'package:flutter_swiper/flutter_swiper.dart';
import 'package:jcs_airport/consts/http_config.dart';
import 'package:jcs_airport/view/common/no_data.dart';

///方位图
class LocationMap extends StatefulWidget {
  final Map _data;

  const LocationMap(this._data);

  @override
  _LocationMapState createState() => _LocationMapState();
}

class _LocationMapState extends State<LocationMap> {
  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        widget._data['orientationImg'] != null
            ? Expanded(
                child: Swiper(
                autoplay: false,
                loop: false,
                itemBuilder: (BuildContext context, int index) =>
                    Image.network(HttpConfig.GateWayURL + '/' + widget._data['orientationImg'][index]['url']),
                itemCount: widget._data['orientationImg'].length,
                pagination: const SwiperPagination(),
              ))
            : const NoData()
      ],
    );
  }
}
